/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import java.util.Vector;

public class TJ_MaxSines {
    public static void main(String[] args) {
        TJ_MaxSines app = new TJ_MaxSines();
        app.test();
        System.exit(1);
    }

    public void test() {
        Vector<SawtoothOscillatorBL> sines = new Vector<SawtoothOscillatorBL>();
        Vector<AddUnit> adders = new Vector<AddUnit>();
        double MIN_FREQ = 200.0;
        double MAX_FREQ = 6000.0;
        double frequency = 200.0;
        int numPairs = 0;
        try {
            Synth.startEngine(0);
            LineOut lineOut = new LineOut();
            MultiplyUnit scaler = new MultiplyUnit();
            lineOut.start();
            scaler.start();
            scaler.output.connect(0, lineOut.input, 0);
            scaler.output.connect(0, lineOut.input, 1);
            AddUnit lastAdder = null;
            while (Synth.getUsage() < 0.8 && sines.size() < 75) {
                SawtoothOscillatorBL sineOsc = new SawtoothOscillatorBL();
                sines.addElement(sineOsc);
                int numForScaling = ++numPairs;
                if (numForScaling < 8) {
                    numForScaling = 8;
                }
                scaler.inputB.set(1.0 / (double)numForScaling);
                frequency *= 1.02;
                if (frequency > 6000.0) {
                    frequency = 200.0;
                }
                sineOsc.frequency.set(frequency);
                AddUnit adder = new AddUnit();
                adders.addElement(adder);
                if (lastAdder == null) {
                    adder.output.connect(scaler.inputA);
                } else {
                    adder.output.connect(lastAdder.inputA);
                }
                sineOsc.output.connect(adder.inputB);
                lastAdder = adder;
                sineOsc.start();
                adder.start();
                if (numPairs <= 10) continue;
                System.out.println("num pairs = " + numPairs + ", usage = " + Synth.getUsage());
                Synth.sleepForTicks((int)(Synth.getTickRate() * 0.1));
            }
            Synth.sleepForTicks((int)(Synth.getTickRate() * 20.0));
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

