/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.ShortSample;
import junit.framework.TestCase;

public class TestShortSample
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBytes() {
        byte[] bar = new byte[]{18, -3};
        short s = (short)(bar[0] << 8 | bar[1] & 0xFF);
        TestShortSample.assertEquals("A", 4861, (int)s);
    }

    public void testReadWrite() {
        short[] sArray = new short[9];
        sArray[0] = 123;
        sArray[1] = 456;
        sArray[2] = -789;
        sArray[3] = 111;
        sArray[4] = 20000;
        sArray[5] = Short.MIN_VALUE;
        sArray[6] = Short.MAX_VALUE;
        sArray[8] = 9876;
        short[] data = sArray;
        ShortSample sample = new ShortSample(data.length, 1);
        TestShortSample.assertEquals("Sample numFrames", data.length, sample.getNumFrames());
        sample.write(data);
        short[] buffer = new short[data.length];
        sample.read(buffer);
        int i = 0;
        while (i < data.length) {
            TestShortSample.assertEquals("read = write", data[i], buffer[i]);
            ++i;
        }
        short[] partial = new short[]{333, 444, 555, 666, 777};
        sample.write(2, partial, 1, 3);
        sample.read(1, buffer, 1, 5);
        int i2 = 0;
        while (i2 < data.length) {
            if (i2 >= 2 && i2 <= 4) {
                TestShortSample.assertEquals("partial", partial[i2 - 1], buffer[i2]);
            } else {
                TestShortSample.assertEquals("read = write", data[i2], buffer[i2]);
            }
            ++i2;
        }
    }
}

