/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.debug;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.unitgen.LineOut;
import com.jsyn.util.VoiceAllocator;
import javax.swing.JApplet;

public class DebugCircuitUsage
extends JApplet {
    private static final long serialVersionUID = 1614628946115373956L;
    private static final int MAX_VOICES = 32;
    private Synthesizer synth;
    private VoiceAllocator allocator;
    private LineOut lineOut;
    private SubtractiveSynthVoice[] voices;

    private void test() throws InterruptedException {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.synth.start();
        this.lineOut.start();
        this.voices = new SubtractiveSynthVoice[32];
        int i = 0;
        while (i < 32) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(0, this.lineOut.input, 0);
            voice.getOutput().connect(0, this.lineOut.input, 1);
            this.voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
        this.printUsage(3.0);
        this.allNotesOn();
        this.printUsage(2.0);
        this.allNotesOff();
        this.printUsage(3.0);
        this.allNotesOn();
        this.printUsage(2.0);
        this.allNotesOff();
        this.printUsage(3.0);
        this.synth.stop();
    }

    private void allNotesOn() {
        System.out.println("All Notes On! ==================");
        double amplitude = 0.03125;
        int i = 0;
        while (i < 32) {
            double frequency = (double)(200 + 50 * i) + Math.random();
            this.allocator.noteOn(40 + i, frequency, amplitude, this.synth.createTimeStamp());
            ++i;
        }
    }

    private void allNotesOff() {
        System.out.println("All Notes Off. -------");
        this.allocator.allNotesOff(this.synth.createTimeStamp());
    }

    private void printUsage(double seconds) throws InterruptedException {
        double timeNow = this.synth.getCurrentTime();
        double timeStop = timeNow + seconds;
        while (this.synth.getCurrentTime() < timeStop) {
            System.out.printf("Usage = %6.4f\n", this.synth.getUsage());
            this.synth.sleepFor(0.2);
        }
    }

    public static void main(String[] args) {
        try {
            new DebugCircuitUsage().test();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

