/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

import com.jsyn.io.AudioFifo;
import junit.framework.TestCase;

public class TestFifo
extends TestCase {
    public void testBasic() {
        Thread watchdog = this.startWatchdog(600);
        AudioFifo fifo = new AudioFifo();
        fifo.setReadWaitEnabled(false);
        fifo.allocate(8);
        TestFifo.assertEquals("start empty", 0, fifo.available());
        TestFifo.assertEquals("read back Nan when emopty", (Object)Double.NaN, (Object)fifo.read());
        fifo.write(1.0);
        TestFifo.assertEquals("added one value", 1, fifo.available());
        TestFifo.assertEquals("read back same value", (Object)1.0, (Object)fifo.read());
        TestFifo.assertEquals("back to empty", 0, fifo.available());
        int i = 0;
        while (i < fifo.size()) {
            TestFifo.assertEquals("adding data", i, fifo.available());
            fifo.write(100.0 + (double)i);
            ++i;
        }
        i = 0;
        while (i < fifo.size()) {
            TestFifo.assertEquals("removing data", fifo.size() - i, fifo.available());
            TestFifo.assertEquals("reading back data", (Object)(100.0 + (double)i), (Object)fifo.read());
            ++i;
        }
        watchdog.interrupt();
    }

    public void testWrapping() {
        int chunk = 5;
        AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        double value = 1000.0;
        int i = 0;
        while (i < fifo.size() * 5) {
            value = this.checkFifoChunk(fifo, value, 5);
            ++i;
        }
    }

    private double checkFifoChunk(AudioFifo fifo, double value, int chunk) {
        int i = 0;
        while (i < chunk) {
            TestFifo.assertEquals("adding data", i, fifo.available());
            fifo.write(value + (double)i);
            ++i;
        }
        i = 0;
        while (i < chunk) {
            TestFifo.assertEquals("removing data", chunk - i, fifo.available());
            TestFifo.assertEquals("reading back data", (Object)(value + (double)i), (Object)fifo.read());
            ++i;
        }
        return value + (double)chunk;
    }

    public void testBadSize() {
        boolean caught = false;
        try {
            AudioFifo fifo = new AudioFifo();
            fifo.allocate(20);
            TestFifo.assertTrue("should not get here", false);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        TestFifo.assertTrue("should have caught size exception", caught);
    }

    public void testSingleReadWait() {
        int chunk = 5;
        final AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        fifo.setWriteWaitEnabled(false);
        fifo.setReadWaitEnabled(true);
        double value = 50.0;
        new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(200L);
                    int i = 0;
                    while (i < 5) {
                        fifo.write(50.0 + (double)i);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Thread watchdog = this.startWatchdog(500);
        int i = 0;
        while (i < 5) {
            TestFifo.assertEquals("reading back data", (Object)(50.0 + (double)i), (Object)fifo.read());
            ++i;
        }
        watchdog.interrupt();
    }

    private Thread startWatchdog(final int msec) {
        Thread watchdog = new Thread(){

            @Override
            public void run() {
                try {
                    2.sleep(msec);
                    TestFifo.assertTrue("test must still be waiting", false);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        watchdog.start();
        return watchdog;
    }

    public void testSingleWriteWait() {
        int chunk = 13;
        final AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        fifo.setWriteWaitEnabled(true);
        fifo.setReadWaitEnabled(true);
        double value = 50.0;
        Thread readThread = new Thread(){

            @Override
            public void run() {
                try {
                    3.sleep(200L);
                    int i = 0;
                    while (i < 13) {
                        double got = fifo.read();
                        TestFifo.assertEquals("adding data", (Object)(50.0 + (double)i), (Object)got);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        readThread.start();
        Thread watchdog = this.startWatchdog(500);
        int i = 0;
        while (i < 13) {
            fifo.write(50.0 + (double)i);
            ++i;
        }
        watchdog.interrupt();
        try {
            readThread.join(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestFifo.assertEquals("readThread should be done.", false, readThread.isAlive());
    }

    public void testBlockReadWait() {
        int chunk = 50;
        final AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        fifo.setWriteWaitEnabled(false);
        fifo.setReadWaitEnabled(true);
        double value = 300.0;
        double[] readBuffer = new double[50];
        new Thread(){

            @Override
            public void run() {
                int numWritten = 0;
                double[] writeBuffer = new double[4];
                try {
                    while (numWritten < 50) {
                        4.sleep(30L);
                        int i = 0;
                        while (i < writeBuffer.length) {
                            writeBuffer[i] = 300.0 + (double)numWritten;
                            ++numWritten;
                            ++i;
                        }
                        fifo.write(writeBuffer);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Thread watchdog = this.startWatchdog(600);
        fifo.read(readBuffer);
        int i = 0;
        while (i < 50) {
            TestFifo.assertEquals("reading back data", (Object)(300.0 + (double)i), (Object)readBuffer[i]);
            ++i;
        }
        watchdog.interrupt();
    }
}

