/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.ExponentialRangeModel;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortModelFactory;
import com.jsyn.swing.RotaryTextController;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SineOscillatorPhaseModulated;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HearSinePM
extends JApplet {
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    SineOscillatorPhaseModulated carrier;
    SineOscillator modulator;
    LineOut lineOut;
    AudioScope scope;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.modulator = new SineOscillator();
        this.synth.add(this.modulator);
        this.carrier = new SineOscillatorPhaseModulated();
        this.synth.add(this.carrier);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.modulator.output.connect(this.carrier.modulation);
        this.carrier.output.connect(0, this.lineOut.input, 0);
        this.carrier.output.connect(0, this.lineOut.input, 1);
        this.modulator.amplitude.setup(0.0, 1.0, 10.0);
        this.carrier.amplitude.setup(0.0, 1.0, 1.0);
        this.setupGUI();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Show Phase Modulation in an AudioScope"), "North");
        JPanel knobPanel = new JPanel();
        knobPanel.setLayout(new GridLayout(1, 0));
        knobPanel.add(this.setupPortKnob(this.modulator.frequency, "MFreq"));
        knobPanel.add(this.setupPortKnob(this.modulator.amplitude, "MAmp"));
        knobPanel.add(this.setupPortKnob(this.carrier.frequency, "CFreq"));
        knobPanel.add(this.setupPortKnob(this.carrier.amplitude, "CAmp"));
        this.add((Component)knobPanel, "South");
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.carrier.output);
        this.scope.addProbe(this.modulator.output);
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.getView().setControlsVisible(true);
        this.add((Component)this.scope.getView(), "Center");
        this.scope.start();
        this.validate();
    }

    private RotaryTextController setupPortKnob(UnitInputPort port, String label) {
        ExponentialRangeModel model = PortModelFactory.createExponentialModel(port);
        RotaryTextController knob = new RotaryTextController(model, 10);
        knob.setBorder(BorderFactory.createTitledBorder(label));
        knob.setTitle(label);
        return knob;
    }

    @Override
    public void start() {
        this.synth.start();
        this.scope.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.scope.stop();
        this.synth.stop();
    }

    public static void main(String[] args) {
        HearSinePM applet = new HearSinePM();
        JAppletFrame frame = new JAppletFrame("Hear Phase Modulation", applet);
        frame.setSize(640, 400);
        frame.setVisible(true);
        frame.test();
    }
}

