/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.Function;
import com.jsyn.unitgen.FunctionOscillator;
import com.jsyn.unitgen.LineOut;

public class PlayFunction {
    Synthesizer synth;
    FunctionOscillator osc;
    LineOut lineOut;

    private void test() {
        this.synth = JSyn.createSynthesizer();
        this.synth.start();
        this.osc = new FunctionOscillator();
        this.synth.add(this.osc);
        Function func = new Function(){

            @Override
            public double evaluate(double input) {
                double s = Math.sin(input * Math.PI * 2.0);
                double cubed = s * s * s;
                return cubed;
            }
        };
        this.osc.function.set(func);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.osc.output.connect(0, this.lineOut.input, 0);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.osc.frequency.set(345.0);
        this.osc.amplitude.set(0.6);
        this.lineOut.start();
        System.out.println("You should now be hearing a sine wave. ---------");
        try {
            double time = this.synth.getCurrentTime();
            this.synth.sleepUntil(time + 4.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Stop playing. -------------------");
        this.synth.stop();
    }

    public static void main(String[] args) {
        new PlayFunction().test();
    }
}

