/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.io;

import com.jsyn.io.AudioInputStream;
import com.jsyn.io.AudioOutputStream;

public class AudioFifo
implements AudioInputStream,
AudioOutputStream {
    private volatile int readIndex;
    private volatile int writeIndex;
    private volatile double[] buffer;
    private int accessMask;
    private int sizeMask;
    private boolean writeWaitEnabled = true;
    private boolean readWaitEnabled = true;
    private Object writeSemaphore = new Object();
    private Object readSemaphore = new Object();

    public void allocate(int size) {
        if (!AudioFifo.isPowerOfTwo(size)) {
            throw new IllegalArgumentException("Size must be a power of two.");
        }
        this.buffer = new double[size];
        this.accessMask = size - 1;
        this.sizeMask = size * 2 - 1;
    }

    public int size() {
        return this.buffer.length;
    }

    public static boolean isPowerOfTwo(int size) {
        return (size & size - 1) == 0;
    }

    @Override
    public int available() {
        return this.writeIndex - this.readIndex & this.sizeMask;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double read() {
        double value = Double.NaN;
        if (this.readWaitEnabled) {
            try {
                while (this.available() < 1) {
                    Object object = this.writeSemaphore;
                    synchronized (object) {
                        this.writeSemaphore.wait();
                    }
                }
                value = this.readOneInternal();
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.readIndex != this.writeIndex) {
            value = this.readOneInternal();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readOneInternal() {
        double value = this.buffer[this.readIndex & this.accessMask];
        this.readIndex = this.readIndex + 1 & this.sizeMask;
        if (this.writeWaitEnabled) {
            Object object = this.readSemaphore;
            synchronized (object) {
                this.readSemaphore.notify();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(double value) {
        if (this.writeWaitEnabled) {
            try {
                while (this.available() == this.buffer.length) {
                    Object object = this.readSemaphore;
                    synchronized (object) {
                        this.readSemaphore.wait();
                    }
                }
                this.writeOneInternal(value);
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.available() != this.buffer.length) {
            this.writeOneInternal(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOneInternal(double value) {
        this.buffer[this.writeIndex & this.accessMask] = value;
        this.writeIndex = this.writeIndex + 1 & this.sizeMask;
        if (this.readWaitEnabled) {
            Object object = this.writeSemaphore;
            synchronized (object) {
                this.writeSemaphore.notify();
            }
        }
    }

    @Override
    public int read(double[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(double[] buffer, int start, int count) {
        if (this.readWaitEnabled) {
            int i = 0;
            while (i < count) {
                buffer[i + start] = this.read();
                ++i;
            }
        } else if (this.available() < count) {
            count = this.available();
        } else {
            int i = 0;
            while (i < count) {
                buffer[i + start] = this.read();
                ++i;
            }
        }
        return count;
    }

    @Override
    public void write(double[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(double[] buffer, int start, int count) {
        int i = 0;
        while (i < count) {
            this.write(buffer[i + start]);
            ++i;
        }
    }

    public void setWriteWaitEnabled(boolean enabled) {
        this.writeWaitEnabled = enabled;
    }

    public void setReadWaitEnabled(boolean enabled) {
        this.readWaitEnabled = enabled;
    }

    public boolean isWriteWaitEnabled() {
        return this.writeWaitEnabled;
    }

    public boolean isReadWaitEnabled() {
        return this.readWaitEnabled;
    }
}

