/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.unitgen.UnitGenerator;
import java.io.PrintStream;

public class InputMixingBlockPart
extends PortBlockPart {
    private double[] mixer = new double[8];
    private double current;

    InputMixingBlockPart(UnitBlockPort unitBlockPort, double defaultValue) {
        super(unitBlockPort, defaultValue);
    }

    @Override
    public double getValue() {
        return this.current;
    }

    @Override
    protected void setValue(double value) {
        this.current = value;
        super.setValue(value);
    }

    @Override
    public double[] getValues() {
        double[] result;
        int numConnections = this.getConnectionCount();
        if (numConnections == 0) {
            result = super.getValues();
        } else if (numConnections == 1) {
            PortBlockPart otherPart = this.getConnection(0);
            result = otherPart.getValues();
        } else {
            PortBlockPart otherPart = this.getConnection(0);
            double[] inputs = otherPart.getValues();
            int i = 0;
            while (i < this.mixer.length) {
                this.mixer[i] = inputs[i];
                ++i;
            }
            int jCon = 1;
            while (jCon < numConnections) {
                otherPart = this.getConnection(jCon);
                inputs = otherPart.getValues();
                int i2 = 0;
                while (i2 < this.mixer.length) {
                    int n = i2;
                    this.mixer[n] = this.mixer[n] + inputs[i2];
                    ++i2;
                }
                ++jCon;
            }
            result = this.mixer;
        }
        this.current = result[0];
        return result;
    }

    private void printIndentation(PrintStream out, int level) {
        int i = 0;
        while (i < level) {
            out.print("    ");
            ++i;
        }
    }

    private String portToString(UnitBlockPort port) {
        UnitGenerator ugen = port.getUnitGenerator();
        return String.valueOf(ugen.getClass().getSimpleName()) + "." + port.getName();
    }

    public void printConnections(PrintStream out, int level) {
        int i = 0;
        while (i < this.getConnectionCount()) {
            PortBlockPart part = this.getConnection(i);
            this.printIndentation(out, level);
            out.println(String.valueOf(this.portToString(this.getPort())) + " <--- " + this.portToString(part.getPort()));
            part.getPort().getUnitGenerator().printConnections(out, level + 1);
            ++i;
        }
    }
}

