/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.data.FloatSample;
import com.jsyn.ports.SequentialDataCrossfade;
import junit.framework.TestCase;

public class TestSequentialData
extends TestCase {
    float[] data1 = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f};
    FloatSample sample1;
    float[] data2 = new float[]{20.0f, 19.0f, 18.0f, 17.0f, 16.0f, 15.0f, 14.0f, 13.0f, 12.0f, 11.0f};
    FloatSample sample2;

    public void testCrossfade() {
        this.sample1 = new FloatSample(this.data1);
        this.sample2 = new FloatSample(this.data2);
        SequentialDataCrossfade xfade = new SequentialDataCrossfade();
        xfade.setup(this.sample1, 4, 3, this.sample2, 1, 6);
        int i = 0;
        while (i < 3) {
            double factor = (double)i / 3.0;
            double value = (1.0 - factor) * (double)this.data1[i + 4] + factor * (double)this.data2[i + 1];
            System.out.println("i = " + i + ", factor = " + factor + ", value = " + value);
            TestSequentialData.assertEquals("crossfade " + i, value, xfade.readDouble(i), 1.0E-5);
            ++i;
        }
        i = 3;
        while (i < 6) {
            TestSequentialData.assertEquals("crossfade " + i, this.sample2.readDouble(i + 1), xfade.readDouble(i), 1.0E-5);
            ++i;
        }
    }
}

