/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSink;
import com.jsyn.unitgen.UnitSource;

public class MixerMono
extends UnitGenerator
implements UnitSink,
UnitSource {
    public UnitInputPort input;
    public UnitInputPort gain;
    public UnitInputPort amplitude;
    public UnitOutputPort output;

    public MixerMono(int numInputs) {
        this.input = new UnitInputPort(numInputs, "Input");
        this.addPort(this.input);
        this.gain = new UnitInputPort(numInputs, "Gain", 1.0);
        this.addPort(this.gain);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.output = new UnitOutputPort(this.getNumOutputs(), "Output");
        this.addPort(this.output);
    }

    public int getNumOutputs() {
        return 1;
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues(0);
        double[] outputs = this.output.getValues(0);
        int i = start;
        while (i < limit) {
            double sum = 0.0;
            int n = 0;
            while (n < this.input.getNumParts()) {
                double[] inputs = this.input.getValues(n);
                double[] gains = this.gain.getValues(n);
                sum += inputs[i] * gains[i];
                ++n;
            }
            outputs[i] = sum * amplitudes[i];
            ++i;
        }
    }

    @Override
    public UnitInputPort getInput() {
        return this.input;
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }
}

