/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.util.AutoCorrelator;
import com.jsyn.util.SignalCorrelator;
import com.jsynx.inprogress.FeatureCorrelator;
import junit.framework.TestCase;

public class TestAutoCorrelator
extends TestCase {
    private static final double TWO_PI = Math.PI * 2;

    public void testPeakInterpolation() {
        TestAutoCorrelator.assertEquals("low", -1.0, AutoCorrelator.interpolatePeak(0.8, 0.7, 0.6), 1.0E-4);
        TestAutoCorrelator.assertEquals("high", 1.0, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.8), 1.0E-4);
        TestAutoCorrelator.assertEquals("flat left", -0.5, AutoCorrelator.interpolatePeak(0.7, 0.7, 0.6), 1.0E-4);
        TestAutoCorrelator.assertEquals("far left", -0.3, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.2), 0.1);
        TestAutoCorrelator.assertEquals("middle left", -0.2, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.5), 0.1);
        TestAutoCorrelator.assertEquals("middle", 0.0, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.6), 1.0E-4);
        TestAutoCorrelator.assertEquals("middle right", 0.2, AutoCorrelator.interpolatePeak(0.5, 0.7, 0.6), 0.1);
        TestAutoCorrelator.assertEquals("far right", 0.3, AutoCorrelator.interpolatePeak(0.2, 0.7, 0.6), 0.1);
        TestAutoCorrelator.assertEquals("flat right", 0.5, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.7), 1.0E-4);
    }

    public void checkComplexWave(SignalCorrelator correlator, double period, double[] partials) {
        int bufferSize = 8192;
        int i = 0;
        while (i < bufferSize * 2) {
            correlator.addSample(0.0);
            ++i;
        }
        double[] phases = new double[partials.length];
        double phaseIncrement = Math.PI * 2 / period;
        double periodSum = 0.0;
        double confidenceSum = 0.0;
        int i2 = 0;
        while (i2 < bufferSize * 5) {
            double confidence;
            double value = 0.0;
            int j = 0;
            while (j < partials.length) {
                value += Math.sin(phases[j]) * partials[j];
                int n = j;
                phases[n] = phases[n] + (double)(j + 1) * phaseIncrement;
                while (phases[j] > Math.PI * 2) {
                    int n2 = j;
                    phases[n2] = phases[n2] - Math.PI * 2;
                }
                ++j;
            }
            if (i2 == 4089) {
                System.out.println("i = " + i2);
            }
            if (correlator.addSample(value) && (double)i2 > 10.0 * period && (confidence = correlator.getConfidence()) > 0.2) {
                double measured = correlator.getPeriod();
                periodSum += measured * correlator.getConfidence();
                confidenceSum += correlator.getConfidence();
                TestAutoCorrelator.assertEquals("instantaneous", period, measured, 0.05 * period);
            }
            ++i2;
        }
        double average = periodSum / confidenceSum;
        System.out.println("expected = " + period + ", average = " + average + ", ratio = " + period / average);
        TestAutoCorrelator.assertTrue("confidence", correlator.getConfidence() > 0.5);
    }

    private void checkSeries(SignalCorrelator correlator, double[] partials) {
        this.checkComplexWave(correlator, 100.0, partials);
        this.checkComplexWave(correlator, 100.1, partials);
        this.checkComplexWave(correlator, 100.5, partials);
        this.checkComplexWave(correlator, 100.9, partials);
        this.checkComplexWave(correlator, 101.0, partials);
        this.checkComplexWave(correlator, 101.2, partials);
        this.checkComplexWave(correlator, 101.7, partials);
        this.checkComplexWave(correlator, 492.1, partials);
        this.checkComplexWave(correlator, 234.5, partials);
        this.checkComplexWave(correlator, 123.4, partials);
        this.checkComplexWave(correlator, 34.7, partials);
    }

    public void checkSingleSine(SignalCorrelator correlator) {
        System.out.println("------------ single sine");
        double[] partials = new double[]{1.0};
        this.checkSeries(correlator, partials);
    }

    public void checkComplex1(SignalCorrelator correlator) {
        System.out.println("------------ typical harmonic");
        double[] partials = new double[]{1.0, 0.5, 0.3, 0.2, 0.1};
        this.checkSeries(correlator, partials);
    }

    public void checkSuboctave(SignalCorrelator correlator) {
        System.out.println("------------ strong second harmonic");
        double[] partials = new double[]{0.4, 1.0, 0.3, 0.2, 0.1};
        this.checkSeries(correlator, partials);
    }

    public void ZtestAutoCorrelator() {
        AutoCorrelator auto = new AutoCorrelator(8192);
        this.checkSingleSine(auto);
        this.checkComplex1(auto);
        this.checkSuboctave(auto);
    }

    public void testFeatureCorrelator() {
        FeatureCorrelator auto = new FeatureCorrelator();
        this.checkSingleSine(auto);
        this.checkComplex1(auto);
        this.checkSuboctave(auto);
    }
}

