/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.compose;

import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.ExponentialRangeModel;
import com.softsynth.compose.ChordProgression;
import com.softsynth.compose.ChordProgressionFactory;
import com.softsynth.compose.Composer;
import com.softsynth.compose.Scale;
import com.softsynth.compose.swing.ComposerSynth;
import com.softsynth.score.ScoreClock;
import com.softsynth.score.ScoreElementPlayer;
import com.softsynth.score.ScorePlayer;
import com.softsynth.score.ScoreQueue;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ComposerThread
implements Runnable {
    private static final double SECONDS_PER_MINUTE = 60.0;
    private ScoreQueue queue;
    private double advance = 0.5;
    private ScoreClock clock;
    private ScorePlayer scorePlayer;
    private volatile boolean go;
    private Thread thread;
    private Composer composer;
    private ExponentialRangeModel tempoModel;
    private DoubleBoundedRangeModel densityModel;
    private DoubleBoundedRangeModel brightnessModel;
    private DefaultComboBoxModel<Scale> scaleModel;
    private ComposerSynth composerEngine;
    private Scale naturalMinorScale;
    private Scale majorScale;
    private Scale harmonicMinorScale;
    private DefaultComboBoxModel<ChordProgression> chordModel;

    public ComposerThread(ScoreClock clock, Composer composer, ComposerSynth composerEngine) {
        this.clock = clock;
        this.composer = composer;
        this.composerEngine = composerEngine;
        this.scorePlayer = new ScorePlayer(clock);
        this.scorePlayer.setAdvance(this.advance);
        this.queue = new ScoreQueue();
        this.queue.setAmplitude(0.3);
        this.setupModel();
    }

    private void setupModel() {
        this.tempoModel = new ExponentialRangeModel("Tempo", 10000, 80.0, 200.0, 120.0);
        this.tempoModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExponentialRangeModel model = (ExponentialRangeModel)e.getSource();
                double beatsPerMinute = model.getDoubleValue();
                ComposerThread.this.clock.setTimeScale(beatsPerMinute / 60.0);
            }
        });
        this.densityModel = new DoubleBoundedRangeModel("Density", 1000, 0.0, 1.0, 0.5);
        this.densityModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleBoundedRangeModel model = (DoubleBoundedRangeModel)e.getSource();
                double value = model.getDoubleValue();
                ComposerThread.this.composer.setDensity(value);
            }
        });
        this.brightnessModel = new DoubleBoundedRangeModel("Density", 1000, 0.0, 1.0, 0.5);
        this.brightnessModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleBoundedRangeModel model = (DoubleBoundedRangeModel)e.getSource();
                double value = model.getDoubleValue();
                ComposerThread.this.composerEngine.setBrightness(value);
            }
        });
        this.scaleModel = new DefaultComboBoxModel();
        int tonic = 48;
        this.majorScale = Scale.createMajorScale(tonic);
        this.scaleModel.addElement(this.majorScale);
        this.naturalMinorScale = Scale.createNaturalMinorScale(tonic);
        this.scaleModel.addElement(this.naturalMinorScale);
        this.harmonicMinorScale = Scale.createHarmonicMinorScale(tonic);
        this.scaleModel.addElement(this.harmonicMinorScale);
        this.scaleModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                System.out.println("added " + e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                System.out.println("removed " + e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                System.out.println("changed " + e + ", " + ComposerThread.this.scaleModel.getSelectedItem());
                ComposerThread.this.composer.setScale((Scale)ComposerThread.this.scaleModel.getSelectedItem());
            }
        });
        this.chordModel = new DefaultComboBoxModel();
        this.chordModel.addElement(ChordProgressionFactory.create14());
        this.chordModel.addElement(ChordProgressionFactory.create15());
        this.chordModel.addElement(ChordProgressionFactory.create1145());
        this.chordModel.addElement(ChordProgressionFactory.create1415());
        this.chordModel.addElement(ChordProgressionFactory.create1454());
        this.chordModel.addElement(ChordProgressionFactory.create1564());
        this.chordModel.addElement(ChordProgressionFactory.create1645());
        this.chordModel.addElement(ChordProgressionFactory.createTwelveBarBlues());
        this.chordModel.addElement(ChordProgressionFactory.createRandom());
        this.chordModel.addElement(ChordProgressionFactory.createRandom());
        this.chordModel.addElement(ChordProgressionFactory.createRandom());
        this.chordModel.addElement(ChordProgressionFactory.createRandom());
        this.chordModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                System.out.println("added " + e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                System.out.println("removed " + e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                System.out.println("changed " + e + ", " + ComposerThread.this.chordModel.getSelectedItem());
                ComposerThread.this.composer.setChordProgression((ChordProgression)ComposerThread.this.chordModel.getSelectedItem());
            }
        });
    }

    @Override
    public void run() {
        this.queue.add(this.composer.nextElement());
        this.queue.add(this.composer.nextElement());
        this.clock.reset(this.advance);
        double nextTime = 0.0;
        ScoreElementPlayer elementPlayer = this.queue.start(null, nextTime);
        while (this.go && !elementPlayer.isDone()) {
            if (this.queue.size() < 1) {
                this.queue.add(this.composer.nextElement());
            }
            try {
                this.scorePlayer.waitUntil(nextTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            nextTime = elementPlayer.advance(nextTime);
        }
        System.out.println("Finished playing.");
    }

    public void start() throws InterruptedException {
        this.stop();
        this.go = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() throws InterruptedException {
        this.go = false;
        if (this.thread != null) {
            this.thread.join(2000L);
            this.thread = null;
        }
    }

    public DoubleBoundedRangeModel getTempoModel() {
        return this.tempoModel;
    }

    public DoubleBoundedRangeModel getDensityModel() {
        return this.densityModel;
    }

    public DoubleBoundedRangeModel getBrightnessModel() {
        return this.brightnessModel;
    }

    public ComboBoxModel<Scale> getScaleModel() {
        return this.scaleModel;
    }

    public void setMinorScaleUsed(boolean useMinor) {
        this.scaleModel.setSelectedItem(useMinor ? this.harmonicMinorScale : this.majorScale);
    }

    public ComboBoxModel<ChordProgression> getChordModel() {
        return this.chordModel;
    }
}

