/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.install;

import com.softsynth.install.Installer;
import com.softsynth.install.InstallerGUI;
import com.softsynth.install.PackageDescriptor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Uninstaller
extends Installer {
    public Uninstaller(InstallerGUI gui) {
        super(gui);
    }

    private void scanForJars(File extFolder, PackageDescriptor descriptor) throws IOException {
        Enumeration names = descriptor.jarNames.elements();
        while (names.hasMoreElements()) {
            String jarName = (String)names.nextElement();
            File libFile = new File(extFolder, jarName);
            if (!libFile.exists()) continue;
            descriptor.jarFiles.put(libFile.getCanonicalPath(), libFile);
        }
    }

    private void scanForNative(File binFolder, PackageDescriptor descriptor) throws IOException {
        Enumeration names = descriptor.nativeLibraryNames.elements();
        while (names.hasMoreElements()) {
            String nativeName = (String)names.nextElement();
            String mappedName = System.mapLibraryName(nativeName);
            File libFile = new File(binFolder, mappedName);
            if (!libFile.exists()) continue;
            descriptor.nativeLibraryFiles.put(libFile.getCanonicalPath(), libFile);
        }
    }

    public void scanJRE(File jreFolder, PackageDescriptor descriptor) throws IOException {
        File binFolder = new File(jreFolder, "bin");
        this.scanForNative(binFolder, descriptor);
        File extFolder = new File(jreFolder, "lib/ext");
        this.scanForJars(extFolder, descriptor);
    }

    public void scan(PackageDescriptor descriptor) throws IOException {
        if (this.determineHost() == 2) {
            this.scanMacintosh(descriptor);
        } else if (this.determineHost() == 1) {
            this.scanWindows(descriptor);
        }
    }

    private void scanWindows(PackageDescriptor descriptor) throws IOException {
        String libraryPath = System.getProperty("java.library.path");
        Vector strings = this.splitString(libraryPath, File.pathSeparatorChar);
        Enumeration dirs = strings.elements();
        while (dirs.hasMoreElements()) {
            String dirName = (String)dirs.nextElement();
            File libDirFile = new File(dirName);
            this.scanForNative(libDirFile, descriptor);
        }
        this.scanForNative(this.getWindowsJavaBinFolder(), descriptor);
        String extPath = System.getProperty("java.ext.dirs");
        strings = this.splitString(extPath, File.pathSeparatorChar);
        dirs = strings.elements();
        while (dirs.hasMoreElements()) {
            String dirName = (String)dirs.nextElement();
            File libDirFile = new File(dirName);
            this.scanForJars(libDirFile, descriptor);
        }
        File javadir = new File("C:/Program Files/Java");
        File[] jreDirs = javadir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jre") || name.startsWith("j2re");
            }
        });
        int i = 0;
        while (i < jreDirs.length) {
            this.scanJRE(jreDirs[i], descriptor);
            ++i;
        }
        File[] jdkDirs = javadir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jdk") || name.startsWith("j2sdk");
            }
        });
        int i2 = 0;
        while (i2 < jdkDirs.length) {
            File jre = new File(jdkDirs[i2], "jre");
            this.scanJRE(jre, descriptor);
            ++i2;
        }
        File topdir = new File("C:/");
        jdkDirs = topdir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jdk") || name.startsWith("j2sdk");
            }
        });
        int i3 = 0;
        while (i3 < jdkDirs.length) {
            File jre = new File(jdkDirs[i3], "jre");
            this.scanJRE(jre, descriptor);
            ++i3;
        }
    }

    private void scanMacintosh(PackageDescriptor descriptor) throws IOException {
        this.scanForNative(Uninstaller.getMacUserExtensionFolder(), descriptor);
        this.scanForJars(Uninstaller.getMacUserExtensionFolder(), descriptor);
    }
}

