/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;

public class SynthNote
extends SynthCircuit {
    public SynthInput frequency;
    public SynthInput amplitude;

    public SynthNote() throws SynthException {
        super(Synth.getSharedContext());
    }

    public SynthNote(SynthContext synthContext) throws SynthException {
        super(synthContext);
    }

    public void noteOn(int time, double frequency, double amplitude) {
        if (this.frequency != null) {
            this.frequency.set(time, frequency);
        }
        if (this.amplitude != null) {
            this.amplitude.set(time, amplitude);
        }
        this.setStage(time, 0);
    }

    public void noteOff(int time) {
        this.setStage(time, 1);
    }

    public void noteOnFor(int time, int duration, double frequency, double amplitude) {
        this.noteOn(time, frequency, amplitude);
        this.noteOff(time + duration);
    }

    public void note(int time, int duration, double frequency, double amplitude) {
        this.noteOn(time, frequency, amplitude);
        this.noteOff(time + duration / 2);
    }
}

