/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AddUnsignedUnit;
import com.softsynth.jsyn.AllUnits;
import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.CompareUnit;
import com.softsynth.jsyn.CrossFade;
import com.softsynth.jsyn.DivideUnit;
import com.softsynth.jsyn.DualInTwoOutUnit;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.Filter_1o1p;
import com.softsynth.jsyn.Filter_1o1p1z;
import com.softsynth.jsyn.Filter_1o1z;
import com.softsynth.jsyn.Filter_2o2p;
import com.softsynth.jsyn.Filter_2o2p2z;
import com.softsynth.jsyn.Filter_BandPass;
import com.softsynth.jsyn.Filter_BandStop;
import com.softsynth.jsyn.Filter_HighPass;
import com.softsynth.jsyn.Filter_HighShelf;
import com.softsynth.jsyn.Filter_LowPass;
import com.softsynth.jsyn.Filter_LowShelf;
import com.softsynth.jsyn.Filter_PeakingEQ;
import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.FourWayFade;
import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.ImpulseOscillatorBL;
import com.softsynth.jsyn.IntegrateUnit;
import com.softsynth.jsyn.InterpolatingDelayUnit;
import com.softsynth.jsyn.LatchUnit;
import com.softsynth.jsyn.LineIn;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.LinearLag;
import com.softsynth.jsyn.MaximumUnit;
import com.softsynth.jsyn.MinimumUnit;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.MultiplyAddUnsignedUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.MultiplyUnsignedUnit;
import com.softsynth.jsyn.PanControlUnit;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.ParabolicEnvelope;
import com.softsynth.jsyn.PeakFollower;
import com.softsynth.jsyn.PinkNoise;
import com.softsynth.jsyn.PitchDetector;
import com.softsynth.jsyn.PulseOscillator;
import com.softsynth.jsyn.PulseOscillatorBL;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.SampleReader_16V2;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.SawtoothOscillatorDPW;
import com.softsynth.jsyn.SchmidtTrigger;
import com.softsynth.jsyn.SelectUnit;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SquareOscillator;
import com.softsynth.jsyn.SquareOscillatorBL;
import com.softsynth.jsyn.SubtractUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthSound;
import com.softsynth.jsyn.SynthUnit;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.TableOscillator;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.TwoInDualOutUnit;
import com.softsynth.jsyn.WaveShaper;
import com.softsynth.jsyn.WhiteNoise;
import com.softsynth.jsyn.bridge.SignalTypeLookup;
import com.softsynth.jsyn.bridge.UnitInfo;
import com.softsynth.jsyn.bridge.UnitsByNameHash;
import junit.framework.TestCase;

public class TestAllUnits
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testCreateAll() {
        boolean allGood = true;
        Class[] classArray = AllUnits.allUnits;
        int n = AllUnits.allUnits.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            try {
                SynthUnit unit = (SynthUnit)cls.newInstance();
                TestAllUnits.assertTrue("Class " + cls.getName() + " created.", unit != null);
                unit.start();
                unit.stop();
            }
            catch (InstantiationException thr) {
                System.err.println("Class " + cls.getName() + " could not be instantiated.");
            }
            catch (Throwable thr) {
                allGood = false;
                TestAllUnits.assertTrue("Class " + cls.getName() + " caused " + thr, false);
            }
            ++n2;
        }
        TestAllUnits.assertTrue("Should have made all units.", allGood);
    }

    public void ZZtestGenerateSignalTypeMap() {
        System.out.println("// ********** BEGIN AUTOGENERATED CODE **************");
        SynthesisEngine synthesisEngine = new SynthesisEngine();
        Class[] classArray = AllUnits.allUnits;
        int n = AllUnits.allUnits.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            try {
                SynthSound nativeUnit = (SynthSound)cls.newInstance();
                String unitName = nativeUnit.getName();
                int key = Synth.hashName(unitName);
                UnitInfo unitInfo = UnitsByNameHash.get(key);
                UnitGenerator pureUnit = unitInfo.createUnit(synthesisEngine, 0);
                int i = 0;
                while (i < nativeUnit.getNumPorts()) {
                    SynthPort port = nativeUnit.getPortAt(i);
                    if (port instanceof SynthVariable) {
                        SynthVariable varPort = (SynthVariable)port;
                        int j = 0;
                        while (j < port.getNumParts()) {
                            SignalTypeLookup.generateCode(pureUnit.getClass(), varPort.getName(), varPort.getSignalType());
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (InstantiationException nativeUnit) {
            }
            catch (Throwable thr) {
                System.err.println("Class " + cls.getName() + " caused " + thr);
            }
            ++n2;
        }
        System.out.println("// ********** END AUTOGENERATED CODE **************");
    }

    public void testGeneratePortCheck() {
        System.out.println("// ********** BEGIN AUTOGENERATED CODE **************");
        Class[] classArray = AllUnits.allUnits;
        int n = AllUnits.allUnits.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            try {
                SynthUnit ugen = (SynthUnit)cls.newInstance();
                System.out.format("ugen = new %s();\n", cls.getName());
                int i = 0;
                while (i < ugen.getNumPorts()) {
                    SynthPort port = ugen.getPortAt(i);
                    if (port instanceof SynthVariable) {
                        SynthVariable varPort = (SynthVariable)port;
                        int j = 0;
                        while (j < port.getNumParts()) {
                            System.out.format("checkVariablePort( ugen, \"%s\", %d, %f, %f, %f );\n", port.getName(), j, varPort.getCurrent(j), varPort.getMin(), varPort.getMax());
                            ++j;
                        }
                    } else {
                        System.out.format("checkPort( ugen, \"%s\" );\n", port.getName());
                    }
                    ++i;
                }
            }
            catch (InstantiationException ugen) {
            }
            catch (Throwable thr) {
                System.err.println("Class " + cls.getName() + " caused " + thr);
            }
            ++n2;
        }
        System.out.println("// ********** END AUTOGENERATED CODE **************");
    }

    public void testPortDefaults() {
        SynthUnit ugen = new AddUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new AddUnsignedUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, 0.0, 2.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, 0.0, 2.0);
        this.checkPort(ugen, "Output");
        ugen = new BusReader();
        this.checkPort(ugen, "BusInput");
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new BusWriter();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "BusOutput");
        ugen = new CompareUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new CrossFade();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Input", 1, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Fade", 0, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "Output");
        ugen = new DivideUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new DualInTwoOutUnit();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Input", 1, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "OutputA");
        this.checkPort(ugen, "OutputB");
        ugen = new EnvelopePlayer();
        this.checkVariablePort(ugen, "Rate", 0, 1.0, 0.0, 2.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkPort(ugen, "Data");
        ugen = new ExponentialLag();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Current", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new Filter_1o1p();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "A0", 0, 0.6, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "B1", 0, -0.3, -100000.0, 100000.0);
        ugen = new Filter_1o1p1z();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "A0", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "A1", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "B1", 0, 0.0, -100000.0, 100000.0);
        ugen = new Filter_1o1z();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "A0", 0, 0.5, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "A1", 0, 0.5, -100000.0, 100000.0);
        ugen = new Filter_2o2p();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "A0", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "B1", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "B2", 0, 0.0, -100000.0, 100000.0);
        ugen = new Filter_2o2p2z();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "A0", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "A1", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "A2", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "B1", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "B2", 0, 0.0, -1.0, 1.0);
        ugen = new Filter_BandPass();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Frequency", 0, 400.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Q", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 1.0, -100000.0, 100000.0);
        ugen = new Filter_BandStop();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Frequency", 0, 400.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Q", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 1.0, -100000.0, 100000.0);
        ugen = new Filter_HighPass();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Frequency", 0, 400.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Q", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 1.0, -100000.0, 100000.0);
        ugen = new Filter_HighShelf();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Frequency", 0, 400.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Gain", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Slope", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 1.0, -100000.0, 100000.0);
        ugen = new Filter_LowPass();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Frequency", 0, 400.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Q", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 1.0, -100000.0, 100000.0);
        ugen = new Filter_LowShelf();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Frequency", 0, 400.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Gain", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Slope", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 1.0, -100000.0, 100000.0);
        ugen = new Filter_PeakingEQ();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Frequency", 0, 400.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Q", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Gain", 0, 1.0, -100000.0, 100000.0);
        ugen = new Filter_StateVariable();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Resonance", 0, 0.2, -1.0, 1.0);
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -1.0, 1.0);
        this.checkPort(ugen, "LowPass");
        this.checkPort(ugen, "BandPass");
        this.checkPort(ugen, "HighPass");
        ugen = new FourWayFade();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Input", 1, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Input", 2, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Input", 3, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Fade", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Fade", 1, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "Output");
        ugen = new ImpulseOscillator();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new ImpulseOscillatorBL();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new IntegrateUnit();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "LowerLimit", 0, -1.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "UpperLimit", 0, 1.0, -100000.0, 100000.0);
        ugen = new InterpolatingDelayUnit();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Delay", 0, 0.0, -100000.0, 100000.0);
        ugen = new LatchUnit();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Gate", 0, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "Output");
        ugen = new LineIn();
        this.checkPort(ugen, "Output");
        ugen = new LineOut();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Input", 1, 0.0, -1.0, 1.0);
        ugen = new LinearLag();
        this.checkVariablePort(ugen, "Time", 0, 0.0, 0.0, 20.0);
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new MaximumUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new MinimumUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new MultiplyAddUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputC", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new MultiplyAddUnsignedUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "InputC", 0, 0.0, 0.0, 2.0);
        this.checkPort(ugen, "Output");
        ugen = new MultiplyUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new MultiplyUnsignedUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, 0.0, 2.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, 0.0, 2.0);
        this.checkPort(ugen, "Output");
        ugen = new PanControlUnit();
        this.checkVariablePort(ugen, "Pan", 0, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "Output");
        ugen = new PanUnit();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Pan", 0, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "Output");
        ugen = new ParabolicEnvelope();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Input", 0, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "TriggerOutput");
        this.checkPort(ugen, "TriggerPass");
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new PeakFollower();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Current", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new PinkNoise();
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new PitchDetector();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Period");
        this.checkPort(ugen, "Confidence");
        ugen = new PulseOscillator();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Width", 0, 0.0, -1.0, 1.0);
        ugen = new PulseOscillatorBL();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Width", 0, 0.0, -1.0, 1.0);
        ugen = new RedNoise();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new SampleReader_16F1();
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Data");
        this.checkPort(ugen, "Output");
        ugen = new SampleReader_16F2();
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Data");
        this.checkPort(ugen, "Output");
        ugen = new SampleReader_16V1();
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Data");
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Rate", 0, 44100.0, 0.0, 88200.0);
        ugen = new SampleReader_16V2();
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Data");
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Rate", 0, 44100.0, 0.0, 88200.0);
        ugen = new SampleWriter_16F1();
        this.checkPort(ugen, "Data");
        this.checkVariablePort(ugen, "Input", 0, 0.0, -1.0, 1.0);
        ugen = new SampleWriter_16F2();
        this.checkPort(ugen, "Data");
        this.checkVariablePort(ugen, "Input", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Input", 1, 0.0, -1.0, 1.0);
        ugen = new SawtoothOscillator();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new SawtoothOscillatorBL();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new SawtoothOscillatorDPW();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new SchmidtTrigger();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "SetLevel", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "ResetLevel", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "OutputPulse");
        this.checkPort(ugen, "Output");
        ugen = new SelectUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "Select", 0, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "Output");
        ugen = new SineOscillator();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new SquareOscillator();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new SquareOscillatorBL();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new SubtractUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new TableOscillator();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, 0.0, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        this.checkPort(ugen, "Table");
        ugen = new TriangleOscillator();
        this.checkVariablePort(ugen, "Frequency", 0, 440.0, 0.0, 10000.0);
        this.checkVariablePort(ugen, "Phase", 0, -0.5, -1.0, 1.0);
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new TwoInDualOutUnit();
        this.checkVariablePort(ugen, "InputA", 0, 0.0, -100000.0, 100000.0);
        this.checkVariablePort(ugen, "InputB", 0, 0.0, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
        ugen = new WaveShaper();
        this.checkVariablePort(ugen, "Input", 0, 0.0, -1.0, 1.0);
        this.checkPort(ugen, "Output");
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Table");
        ugen = new WhiteNoise();
        this.checkVariablePort(ugen, "Amplitude", 0, 0.999969, -100000.0, 100000.0);
        this.checkPort(ugen, "Output");
    }

    private void checkPort(SynthUnit ugen, String name) {
        String portName = String.valueOf(ugen.getClass().getName()) + ", " + name;
        SynthPort port = ugen.findNamedPort(name);
        TestAllUnits.assertTrue(String.valueOf(portName) + " should exist.", port != null);
    }

    private void checkVariablePort(SynthUnit ugen, String name, int partNum, double expectedValue, double expectedMin, double expectedMax) {
        SynthVariable port = (SynthVariable)ugen.findNamedPort(name);
        String portName = String.valueOf(ugen.getClass().getName()) + ", " + name;
        TestAllUnits.assertEquals(String.valueOf(portName) + " default", expectedValue, port.getCurrent(partNum), 0.001);
        TestAllUnits.assertEquals(String.valueOf(portName) + " min", expectedMin, port.getMin(), 0.001);
        TestAllUnits.assertEquals(String.valueOf(portName) + " max", expectedMax, port.getMax(), 0.001);
    }
}

