/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.Synth;
import junit.framework.TestCase;

public class TestBusConnections
extends TestCase {
    BusWriter writer1;
    BusWriter writer2;
    BusWriter writer3;
    BusReader reader1;

    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
        this.writer1 = new BusWriter();
        this.writer2 = new BusWriter();
        this.writer3 = new BusWriter();
        this.reader1 = new BusReader();
        this.writer1.start();
        this.writer2.start();
        this.writer3.start();
        this.reader1.start();
        this.writer1.input.set(1.0);
        this.writer2.input.set(2.0);
        this.writer3.input.set(4.0);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testSingleConnection() {
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("read should be zero when nothing connected", 0.0, this.reader1.output.get(), 1.0E-4);
        this.writer1.busOutput.connect(this.reader1.busInput);
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("should be writer1 value", 1.0, this.reader1.output.get(), 1.0E-4);
        this.writer1.busOutput.disconnect();
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("read should be zero when nothing connected", 0.0, this.reader1.output.get(), 1.0E-4);
    }

    public void testMultipleConnections() {
        double tolerance = 0.001;
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("reader should be zero when nothing connected", 0.0, this.reader1.output.get(), tolerance);
        this.writer1.busOutput.connect(this.reader1.busInput);
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("should be writer1 value", 1.0, this.reader1.output.get(), tolerance);
        this.writer2.busOutput.connect(this.reader1.busInput);
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("should be writer1 value", 3.0, this.reader1.output.get(), tolerance);
        this.writer3.busOutput.connect(this.reader1.busInput);
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("should be writer1 value", 7.0, this.reader1.output.get(), tolerance);
        this.writer1.busOutput.disconnect();
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("just mix of w2 and w3", 6.0, this.reader1.output.get(), tolerance);
        this.writer2.busOutput.disconnect();
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("just w3", 4.0, this.reader1.output.get(), tolerance);
        this.writer3.busOutput.disconnect();
        Synth.sleepForTicks(1);
        TestBusConnections.assertEquals("reader should be zero when nothing connected", 0.0, this.reader1.output.get(), tolerance);
    }
}

