/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.bridge;

import com.jsyn.data.DoubleTable;
import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.data.SequentialData;
import com.jsyn.data.ShortSample;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.engine.SynthesisEngine;
import com.jsyn.exceptions.ChannelMismatchException;
import com.jsyn.ports.GettablePort;
import com.jsyn.ports.QueueDataCommand;
import com.jsyn.ports.SettablePort;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.ports.UnitDataQueuePort;
import com.jsyn.ports.UnitFunctionPort;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.jsyn.CSynAudioInterface;
import com.softsynth.jsyn.CSynInterface;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.bridge.CSynErrors;
import com.softsynth.jsyn.bridge.PortsByNameHash;
import com.softsynth.jsyn.bridge.SignalTypeLookup;
import com.softsynth.jsyn.bridge.ThingTable;
import com.softsynth.jsyn.bridge.UnitBusInputPort;
import com.softsynth.jsyn.bridge.UnitInfo;
import com.softsynth.jsyn.bridge.UnitsByNameHash;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSynJavaImplementation
implements CSynInterface,
CSynAudioInterface {
    private SynthesisEngine synthesisEngine;
    private ThingTable things;
    private double tickPeriod;
    private boolean useRealTime;
    private int openCount;
    private int startCount;
    private AudioDeviceManager audioDevice;
    private Level logLevel = Level.FINE;
    private static Logger logger = Logger.getLogger("com.softsynth.jsyn.bridge.CSynJavaImplementation");

    public CSynJavaImplementation() {
        this.audioDevice = AudioDeviceFactory.createAudioDeviceManager();
    }

    @Override
    public synchronized void initialize() throws SynthException {
        logger.log(this.logLevel, "initialize: openCount = " + this.openCount);
        if (this.openCount == 0) {
            this.synthesisEngine = new SynthesisEngine();
            logger.log(this.logLevel, "initialize: synthesisEngine = " + this.synthesisEngine);
            this.synthesisEngine.setPullDataEnabled(false);
            this.things = new ThingTable();
            this.tickPeriod = 1.0 / this.getTickRate();
        }
        ++this.openCount;
    }

    @Override
    public synchronized void terminate() {
        logger.log(this.logLevel, "terminate: openCount = " + this.openCount);
        if (this.openCount == 1) {
            logger.log(this.logLevel, "synthesisEngine was " + this.synthesisEngine);
            this.synthesisEngine.terminate();
            this.things.clear();
            this.things = null;
        }
        if (this.openCount > 0) {
            --this.openCount;
        }
    }

    @Override
    public synchronized void delete() {
    }

    @Override
    public double getUsage() {
        return this.synthesisEngine.getUsage();
    }

    @Override
    public int getObjectCount() {
        return this.things.size();
    }

    @Override
    public int getFrameCount() {
        return (int)this.synthesisEngine.getFrameCount();
    }

    @Override
    public int getTickCount() {
        return (int)(this.synthesisEngine.getFrameCount() >> 6);
    }

    @Override
    public int getFramesPerTick() {
        return 64;
    }

    @Override
    public double getFrameRate() {
        return this.synthesisEngine.getFrameRate();
    }

    @Override
    public double getTickRate() {
        return this.getFrameRate() / (double)this.getFramesPerTick();
    }

    @Override
    public int createUnit(int unitHash, int rate, int param) {
        UnitInfo unitInfo = UnitsByNameHash.get(unitHash);
        if (unitInfo == null) {
            throw new SynthException("Unimplemented unit generator.");
        }
        UnitGenerator unit = unitInfo.createUnit(this.synthesisEngine, param);
        return this.things.addThing(unit);
    }

    @Override
    public int stopUnit(int unitToken) {
        return this.stopUnitAt(this.getTickCount(), unitToken);
    }

    @Override
    public int startUnit(int unitToken) {
        return this.startUnitAt(this.getTickCount(), unitToken);
    }

    @Override
    public int stopUnitAt(int time, int unitToken) {
        UnitGenerator unit = this.tokenToUnit(unitToken);
        TimeStamp timeStamp = this.createTimeStamp(time);
        this.synthesisEngine.stopUnit(unit, timeStamp);
        return 0;
    }

    @Override
    public int startUnitAt(int time, int unitToken) {
        UnitGenerator unit = this.tokenToUnit(unitToken);
        TimeStamp timeStamp = this.createTimeStamp(time);
        this.synthesisEngine.startUnit(unit, timeStamp);
        return 0;
    }

    @Override
    public int setPort(int token, int portHash, int partNum, double value) {
        return this.setPortAt(this.getTickCount(), token, portHash, partNum, value);
    }

    private TimeStamp createTimeStamp(int jsynTime) {
        return new TimeStamp((double)jsynTime * this.tickPeriod);
    }

    @Override
    public int setPortAt(int time, int token, int portHash, int partNum, double value) {
        SettablePort port = (SettablePort)((Object)this.lookupPort(token, portHash));
        logger.log(this.logLevel, "set port " + port.getName() + " on token = " + token + " to " + value);
        if (partNum >= port.getNumParts()) {
            return -96;
        }
        TimeStamp timeStamp = this.createTimeStamp(time);
        port.set(partNum, value, timeStamp);
        return 0;
    }

    @Override
    public double getPort(int token, int portHash, int partNum) {
        GettablePort port = (GettablePort)((Object)this.lookupPort(token, portHash));
        if (partNum >= port.getNumParts()) {
            return -96.0;
        }
        return port.getValue(partNum);
    }

    @Override
    public int setPortSignalType(int token, int portHash, int partNum, int signalType) {
        return 0;
    }

    @Override
    public int getPortSignalType(int token, int portHash, int partNum) {
        SettablePort port = (SettablePort)((Object)this.lookupPort(token, portHash));
        int signalType = SignalTypeLookup.getSignalType(port.getUnitGenerator().getClass(), port.getName());
        return signalType;
    }

    @Override
    public int getNumParts(int token, int portHash) {
        UnitPort port = this.lookupPort(token, portHash);
        return port.getNumParts();
    }

    @Override
    public int connectUnits(int srcUnitToken, int srcPortHash, int srcPartNum, int destUnitToken, int destPortHash, int destPartNum) {
        UnitOutputPort srcPort = (UnitOutputPort)this.lookupPort(srcUnitToken, srcPortHash);
        UnitInputPort destPort = (UnitInputPort)this.lookupPort(destUnitToken, destPortHash);
        if (srcPartNum >= srcPort.getNumParts()) {
            return -96;
        }
        if (destPartNum >= destPort.getNumParts()) {
            return -96;
        }
        if (!(destPort instanceof UnitBusInputPort)) {
            destPort.disconnectAll(destPartNum);
        }
        destPort.connect(destPartNum, srcPort, srcPartNum);
        return 0;
    }

    @Override
    public int disconnectUnits(int unitToken, int portHash, int partNum) {
        UnitBlockPort port = (UnitBlockPort)this.lookupPort(unitToken, portHash);
        port.disconnectAll(partNum);
        return 0;
    }

    private UnitPort lookupPort(int unitToken, int portHash) {
        String portName;
        UnitGenerator unit = this.tokenToUnit(unitToken);
        UnitPort port = unit.getPortByName(portName = PortsByNameHash.get(portHash));
        if (port == null) {
            throw new SynthException("Port " + portName + " not found on unit " + unit);
        }
        return port;
    }

    private UnitGenerator tokenToUnit(int token) {
        if (this.things == null) {
            throw new SynthException(-83, "Engine not initialized.");
        }
        return (UnitGenerator)this.things.tokenToThing(token);
    }

    @Override
    public int setPriority(int token, int priority) {
        return 0;
    }

    @Override
    public int getPriority(int token) {
        return 0;
    }

    @Override
    public int createTable(int numFrames) {
        DoubleTable table = new DoubleTable(numFrames);
        return this.things.addThing(table);
    }

    @Override
    public int writeTable(int tableToken, int startFrame, int numFrames, short[] data, int startIndex, int dataLength) {
        DoubleTable table = (DoubleTable)this.things.tokenToThing(tableToken);
        table.write(startFrame, data, startIndex, numFrames);
        return 0;
    }

    @Override
    public int writeTableDoubles(int tableToken, int startFrame, int numFrames, double[] data, int startIndex, int dataLength) {
        DoubleTable table = (DoubleTable)this.things.tokenToThing(tableToken);
        table.write(startFrame, data, startIndex, numFrames);
        return 0;
    }

    @Override
    public int useTable(int unitToken, int portHash, int partNum, int tableToken) {
        UnitFunctionPort port = (UnitFunctionPort)this.lookupPort(unitToken, portHash);
        DoubleTable table = (DoubleTable)this.things.tokenToThing(tableToken);
        if (table == null) {
            throw new SynthException("SynthTable not found.");
        }
        if (partNum > 0) {
            throw new SynthException("Multiple parts not supported in SynthTablePort.");
        }
        port.set(table);
        return 0;
    }

    @Override
    public int createEnvelope(int numFrames) {
        SegmentedEnvelope envelope = new SegmentedEnvelope(numFrames);
        return this.things.addThing(envelope);
    }

    @Override
    public int writeEnvelope(int token, int startFrame, int numFrames, double[] data, int startIndex, int dataLength) {
        SegmentedEnvelope envelope = (SegmentedEnvelope)this.things.tokenToThing(token);
        envelope.write(startFrame, data, startIndex, numFrames);
        return 0;
    }

    @Override
    public int readEnvelope(int token, int startFrame, int numFrames, double[] data, int startIndex, int dataLength) {
        SegmentedEnvelope envelope = (SegmentedEnvelope)this.things.tokenToThing(token);
        envelope.read(startFrame, data, startIndex, numFrames);
        return 0;
    }

    @Override
    public int createSample(int numFrames, int channelsPerFrame) {
        ShortSample sample = new ShortSample(numFrames, channelsPerFrame);
        return this.things.addThing(sample);
    }

    @Override
    public int writeSample(int token, int startFrame, int numFrames, short[] data, int startIndex, int dataLength) {
        ShortSample sample = (ShortSample)this.things.tokenToThing(token);
        sample.write(startFrame, data, startIndex, numFrames);
        return 0;
    }

    @Override
    public int readSample(int token, int startFrame, int numFrames, short[] data, int startIndex, int dataLength) {
        ShortSample sample = (ShortSample)this.things.tokenToThing(token);
        sample.read(startFrame, data, startIndex, numFrames);
        return 0;
    }

    @Override
    public int clearDataQueue(int unitToken, int portHash) {
        UnitDataQueuePort port = (UnitDataQueuePort)this.lookupPort(unitToken, portHash);
        port.clear();
        return 0;
    }

    @Override
    public int clearDataQueueAt(int time, int unitToken, int portHash) {
        UnitDataQueuePort port = (UnitDataQueuePort)this.lookupPort(unitToken, portHash);
        TimeStamp timeStamp = this.createTimeStamp(time);
        port.clear(timeStamp);
        return 0;
    }

    @Override
    public int queueData(int unitToken, int portHash, int sampleToken, int startFrame, int numFrames, int flags) {
        return this.queueDataAt(this.getTickCount(), unitToken, portHash, sampleToken, startFrame, numFrames, flags);
    }

    @Override
    public int queueDataAt(int time, int unitToken, int portHash, int dataToken, int startFrame, int numFrames, int flags) {
        logger.log(this.logLevel, "queue dataToken = " + dataToken + ", startFrame = " + startFrame + ", numFrames = " + numFrames + ", flags = " + flags);
        UnitDataQueuePort port = (UnitDataQueuePort)this.lookupPort(unitToken, portHash);
        SequentialData sample = (SequentialData)this.things.tokenToThing(dataToken);
        if (sample == null) {
            throw new SynthException("SynthSample not found.");
        }
        TimeStamp timeStamp = this.createTimeStamp(time);
        try {
            QueueDataCommand command = port.createQueueDataCommand(sample, startFrame, numFrames);
            if ((flags & 0x10) != 0) {
                command.setAutoStop(true);
            }
            if ((flags & 8) != 0) {
                command.setNumLoops(-1);
            }
            if ((flags & 0x80) != 0) {
                command.setSkipIfOthers(true);
            }
            this.synthesisEngine.scheduleCommand(timeStamp, (ScheduledCommand)command);
        }
        catch (ChannelMismatchException exc) {
            return -66;
        }
        return 0;
    }

    @Override
    public int getPortFrames(int unitToken, int portHash, int partNum) {
        UnitDataQueuePort port = (UnitDataQueuePort)this.lookupPort(unitToken, portHash);
        int framesMoved = (int)port.getFrameCount();
        if (framesMoved == -1) {
            framesMoved = -2;
        }
        return framesMoved;
    }

    @Override
    public int createCircuit(int[] tokens, int numUnits, int flags) throws SynthException {
        Circuit circuit = new Circuit();
        int[] nArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            int token = nArray[n2];
            UnitGenerator unit = this.tokenToUnit(token);
            circuit.add(unit);
            ++n2;
        }
        return this.things.addThing(circuit);
    }

    @Override
    public int delete(int token) {
        this.things.freeToken(token);
        return 0;
    }

    @Override
    public void setTrace(int mask) {
    }

    @Override
    public int getTrace() {
        return 0;
    }

    @Override
    public void checkEngineErrors() {
    }

    @Override
    public int debug(int id, int data) {
        return 0;
    }

    @Override
    public int errorCodeToText(int errorCode, byte[] text, int textSize) {
        String msg = CSynErrors.errorCodeToText(errorCode);
        int numToCopy = msg.length() < text.length ? msg.length() : text.length;
        msg.getBytes(0, numToCopy, text, 0);
        return numToCopy;
    }

    @Override
    public int getVersion() {
        return 151;
    }

    @Override
    public int sleepUntilTick(int tick) {
        int now = this.getTickCount();
        while (tick - now > 0) {
            if (this.useRealTime) {
                throw new RuntimeException("Low level sleepUntilTick called in real-time mode!");
            }
            this.synthesisEngine.generateNextBuffer();
            now = this.getTickCount();
        }
        return 0;
    }

    @Override
    public void stop() {
        logger.log(this.logLevel, "startCount = " + this.startCount);
        if (this.startCount == 1) {
            logger.log(this.logLevel, "stopping!");
            this.synthesisEngine.stop();
        }
        if (this.startCount > 0) {
            --this.startCount;
        }
    }

    @Override
    public void startDevices(int flags, double frameRate, int inputDeviceID, int numInputChannels, int outputDeviceID, int numOutputChannels) {
        logger.log(this.logLevel, "startCount = " + this.startCount);
        if (this.startCount == 0) {
            this.synthesisEngine.setRealTime((flags & 4) == 0);
            this.synthesisEngine.start((int)frameRate, inputDeviceID, numInputChannels, outputDeviceID, numOutputChannels);
        }
        ++this.startCount;
    }

    @Override
    public int getNumDevices() {
        return this.audioDevice.getDeviceCount();
    }

    @Override
    public int getDefaultInputDeviceID() {
        return this.audioDevice.getDefaultInputDeviceID();
    }

    @Override
    public int getDefaultOutputDeviceID() {
        return this.audioDevice.getDefaultOutputDeviceID();
    }

    @Override
    public int getMaxInputChannels(int deviceID) {
        return this.audioDevice.getMaxInputChannels(deviceID);
    }

    @Override
    public int getMaxOutputChannels(int deviceID) {
        return this.audioDevice.getMaxOutputChannels(deviceID);
    }

    @Override
    public int setSuggestedInputLatency(double latency) {
        return this.audioDevice.setSuggestedInputLatency(latency);
    }

    @Override
    public int setSuggestedOutputLatency(double latency) {
        return this.audioDevice.setSuggestedOutputLatency(latency);
    }

    @Override
    public double getOutputLatency() {
        return this.synthesisEngine.getOutputLatency();
    }

    @Override
    public double getInputLatency() {
        return this.synthesisEngine.getInputLatency();
    }

    @Override
    public double getDefaultHighInputLatency(int deviceID) {
        return this.audioDevice.getDefaultHighInputLatency(deviceID);
    }

    @Override
    public double getDefaultHighOutputLatency(int deviceID) {
        return this.audioDevice.getDefaultHighOutputLatency(deviceID);
    }

    @Override
    public double getDefaultLowInputLatency(int deviceID) {
        return this.audioDevice.getDefaultLowInputLatency(deviceID);
    }

    @Override
    public double getDefaultLowOutputLatency(int deviceID) {
        return this.audioDevice.getDefaultLowOutputLatency(deviceID);
    }

    @Override
    public int getDeviceName(int deviceID, byte[] text, int textSize) {
        String devName = this.audioDevice.getDeviceName(deviceID);
        int numToCopy = devName.length() < text.length ? devName.length() : text.length;
        devName.getBytes(0, numToCopy, text, 0);
        return numToCopy;
    }
}

