/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.bridge;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class PitchDetector
extends UnitGenerator {
    public UnitInputPort input;
    public UnitOutputPort periodPort;
    public UnitOutputPort confidencePort;
    private double sampleRate;
    private double period;
    private double confidence;
    private double score;
    private double newPeriod;
    private double maxPeriod;
    private double minPeriod;
    private int countdown;
    private double previousLevel;
    private double previousSlope;
    private double previousMinimum;
    private double previousMaximum;
    private double hysteresisLevel;
    private HysteresisState hysteresisState;
    private int numFeatures;
    private int featureIndex;
    private short index;
    private static final int MAX_FEATURES_CONSIDER = 40;
    private static final int MINIMUM_FREQUENCY = 20;
    private static final int MAXIMUM_FREQUENCY = 2400;
    private static final int NUM_FEATURES = 256;
    private static final int NUM_FEATURE_MASK = 255;
    private FeatureRecord[] features = new FeatureRecord[256];

    public PitchDetector() {
        this.input = new UnitInputPort("Input");
        this.addPort(this.input);
        this.periodPort = new UnitOutputPort("Period");
        this.addPort(this.periodPort);
        this.confidencePort = new UnitOutputPort("Confidence");
        this.addPort(this.confidencePort);
        this.features = new FeatureRecord[256];
        int i = 0;
        while (i < 256) {
            this.features[i] = new FeatureRecord();
            ++i;
        }
        this.hysteresisLevel = 0.01;
        this.newPeriod = this.period = 100.0;
    }

    @Override
    public void setSynthesisEngine(SynthesisEngine synthesisEngine) {
        super.setSynthesisEngine(synthesisEngine);
        this.sampleRate = synthesisEngine.getFrameRate();
        this.maxPeriod = this.sampleRate / 20.0;
        this.minPeriod = this.sampleRate / 2400.0;
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] periods = this.periodPort.getValues();
        double[] confidences = this.confidencePort.getValues();
        int i = start;
        while (i < limit) {
            this.analyze(inputs[i]);
            periods[i] = this.period;
            confidences[i] = this.confidence;
            ++i;
        }
    }

    private FeatureRecord GetNextFeatureRecord() {
        FeatureRecord rec = this.features[this.featureIndex++];
        this.featureIndex &= 0xFF;
        ++this.numFeatures;
        if (this.numFeatures >= 255) {
            this.numFeatures = 255;
        }
        return rec;
    }

    private double CalculateSimilarity(double x, double y) {
        double diff = x - y;
        double diff2 = diff * diff;
        double sum = x + y;
        double sum2 = sum * sum;
        if (sum < 1.0) {
            sum = 1.0;
        }
        double result = 1.0 - diff2 / sum2;
        return result;
    }

    private void MatchFeatures() {
        double bestPeriod = this.maxPeriod;
        double bestScore = 0.0;
        if (this.numFeatures < 4) {
            return;
        }
        int topIndex = this.featureIndex - 1 & 0xFF;
        FeatureRecord topRec = this.features[topIndex];
        int numCheck = this.numFeatures / 2 < 40 ? this.numFeatures / 2 : 40;
        int i = 1;
        while (i < numCheck) {
            int candidateIndex = topIndex - i & 0xFF;
            FeatureRecord candidateRec = this.features[candidateIndex];
            double candidatePeriod = this.CalculatePeriod(topRec, candidateRec);
            if (candidatePeriod > this.maxPeriod) break;
            double periodSum = 0.0;
            if (candidateRec.type == topRec.type && candidatePeriod > this.minPeriod) {
                int startIndex = candidateIndex;
                FeatureRecord rec1 = null;
                FeatureRecord rec2 = null;
                double candidateScore = 0.0;
                int numFeaturesMatched = 0;
                int numTried = 0;
                int index1 = topIndex;
                while (index1 != candidateIndex && numFeaturesMatched < 40) {
                    double periodX = 0.0;
                    rec1 = this.features[index1];
                    while (startIndex != topIndex && (periodX = this.CalculatePeriod(rec1, rec2 = this.features[startIndex])) < 0.95 * candidatePeriod) {
                        startIndex = startIndex - 1 & 0xFF;
                    }
                    if (startIndex == topIndex) break;
                    int index2 = startIndex;
                    ++numTried;
                    while (periodX < 1.05 * candidatePeriod && numFeaturesMatched < 40) {
                        if (rec1.type == rec2.type) {
                            double contribution = rec1.value * rec2.value;
                            candidateScore += contribution;
                            periodSum += periodX * contribution;
                            ++numFeaturesMatched;
                        }
                        if ((index2 = index2 - 1 & 0xFF) == topIndex) break;
                        rec2 = this.features[index2];
                        periodX = this.CalculatePeriod(rec1, rec2);
                    }
                    index1 = index1 - 1 & 0xFF;
                }
                if (numFeaturesMatched > 0) {
                    double averagePeriod = periodSum / candidateScore;
                    double normalScore = candidateScore / ((double)numTried * averagePeriod);
                    double similarity = this.CalculateSimilarity(averagePeriod, this.period);
                    double boost = 0.4 * this.score * similarity;
                    if ((normalScore += boost) > bestScore) {
                        bestScore = normalScore;
                        bestPeriod = averagePeriod;
                    }
                }
            }
            ++i;
        }
        if (bestScore > 0.0) {
            if ((bestPeriod > 0.9 * this.period && bestPeriod < 1.1 * this.period || bestPeriod > 0.9 * this.newPeriod && bestPeriod < 1.1 * this.newPeriod) && bestScore > 0.2 * this.score) {
                this.countdown = (int)bestPeriod;
                this.period = bestPeriod;
                this.score = bestScore;
                this.confidence = bestScore * bestPeriod;
            }
            this.newPeriod = bestPeriod;
        }
    }

    private double CalculatePeriod(FeatureRecord rec1, FeatureRecord rec2) {
        return (double)(rec1.index - rec2.index) + (rec1.fraction - rec2.fraction);
    }

    private void analyze(double level) {
        double delta;
        int featuresAdded = 0;
        boolean gotEdge = false;
        double slope = level - this.previousLevel;
        if (this.hysteresisState == HysteresisState.GoingUp) {
            delta = level - this.hysteresisLevel;
            if (delta > 0.0) {
                this.hysteresisState = HysteresisState.GoingDown;
                gotEdge = true;
            }
        } else {
            delta = level - -this.hysteresisLevel;
            if (delta < 0.0) {
                this.hysteresisState = HysteresisState.GoingUp;
                gotEdge = true;
            }
        }
        if (gotEdge) {
            FeatureRecord rec = this.GetNextFeatureRecord();
            rec.value = 10.0 * slope;
            rec.index = (short)(this.index - 1);
            rec.fraction = 1.0 - delta / slope;
            rec.type = this.hysteresisState == HysteresisState.GoingDown ? FeatureType.RisingZeroCrossing : FeatureType.FallingZeroCrossing;
            this.MatchFeatures();
            ++featuresAdded;
        }
        if (slope < 0.0 ^ this.previousSlope < 0.0) {
            FeatureType type = FeatureType.Unspecified;
            if (slope - this.previousSlope > 0.0) {
                if (level < 0.9 * this.previousMaximum) {
                    type = FeatureType.LocalMinimum;
                    this.previousMinimum = level;
                }
            } else if (level > 0.9 * this.previousMinimum) {
                type = FeatureType.LocalMaximum;
                this.previousMaximum = level;
            }
            if (type != FeatureType.Unspecified) {
                FeatureRecord rec = this.GetNextFeatureRecord();
                rec.value = level;
                rec.type = slope - this.previousSlope > 0.0 ? FeatureType.LocalMinimum : FeatureType.LocalMaximum;
                rec.index = (short)(this.index - 1);
                rec.fraction = 1.0 - slope / rec.value;
                ++featuresAdded;
            }
        }
        this.previousLevel = level;
        this.previousSlope = slope;
        this.index = (short)(this.index + 1);
        if (this.countdown <= 0) {
            this.score *= (double)0.999f;
            if (this.score < 1.0E-20) {
                this.score = 0.0;
            }
            this.confidence = this.score * this.period;
        } else {
            --this.countdown;
        }
    }

    private Object CalculatePosition(FeatureRecord rec) {
        return (double)rec.index + rec.fraction;
    }

    static class ExtraParameter {
        double value;

        ExtraParameter() {
        }
    }

    static class FeatureRecord {
        FeatureType type = FeatureType.Unspecified;
        short index;
        double fraction;
        double value;

        FeatureRecord() {
        }
    }

    static enum FeatureType {
        Unspecified,
        RisingZeroCrossing,
        LocalMaximum,
        FallingZeroCrossing,
        LocalMinimum;

    }

    static enum HysteresisState {
        GoingUp,
        GoingDown;

    }
}

