/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;

public class FilteredSawtoothBL
extends SynthNote {
    public Filter_StateVariable myFilter;
    public EnvelopePlayer myEnv;
    public SynthEnvelope myEnvData;
    public MultiplyUnit freqScalar;
    public SawtoothOscillatorBL sawBL;
    int numFrames;
    public SynthInput cutoff;
    public SynthInput resonance;
    public SynthInput rate;

    public FilteredSawtoothBL() throws SynthException {
        this(Synth.getSharedContext());
    }

    public FilteredSawtoothBL(SynthContext synthContext) throws SynthException {
        super(synthContext);
        this.myFilter = new Filter_StateVariable(synthContext);
        this.add(this.myFilter);
        this.myEnv = new EnvelopePlayer(synthContext);
        this.add(this.myEnv);
        this.freqScalar = new MultiplyUnit(synthContext);
        this.add(this.freqScalar);
        this.sawBL = new SawtoothOscillatorBL(synthContext);
        this.add(this.sawBL);
        double[] data = new double[]{0.1, 0.9, 0.1, 0.5, 0.5, 0.0};
        this.numFrames = data.length / 2;
        this.myEnvData = new SynthEnvelope(synthContext, data);
        this.myEnv.output.connect(this.myFilter.amplitude);
        this.myEnv.output.connect(this.freqScalar.inputA);
        this.freqScalar.output.connect(this.myFilter.frequency);
        this.sawBL.output.connect(this.myFilter.input);
        this.frequency = this.sawBL.frequency;
        this.addPort(this.frequency);
        this.amplitude = this.sawBL.amplitude;
        this.addPort(this.amplitude);
        this.cutoff = this.freqScalar.inputB;
        this.addPort(this.cutoff, "cutoff");
        this.resonance = this.myFilter.resonance;
        this.addPort(this.resonance);
        this.rate = this.myEnv.rate;
        this.addPort(this.rate);
        this.output = this.myFilter.output;
        this.addPort(this.output);
        this.amplitude.setup(0.0, 0.3, 1.0);
        this.frequency.setup(0.0, 160.0, 2000.0);
        this.cutoff.setup(0.0, 1000.0, 4000.0);
        this.resonance.setup(0.0, 0.5, 0.9);
        this.rate.set(1.0);
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        switch (stage) {
            case 0: {
                this.myEnv.envelopePort.clear(time);
                this.myEnv.envelopePort.queue(time, this.myEnvData, 0, this.numFrames - 1);
                this.start(time);
                break;
            }
            case 1: {
                this.myEnv.envelopePort.queue(time, this.myEnvData, this.numFrames - 1, 1, 16);
            }
        }
    }
}

