/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.TriangleOscillator;

public class Swarm
extends SynthNote {
    static final int NUM_ELEMENTS = 10;
    ExponentialLag[] lags = new ExponentialLag[10];
    TriangleOscillator[] oscillators = new TriangleOscillator[10];
    BusWriter[] mixers = new BusWriter[10];
    BusReader reader = new BusReader();
    MultiplyUnit myScalar;
    MultiplyAddUnit myOffsetter;
    MultiplyUnit amplPlug;

    public Swarm() throws SynthException {
        this.add(this.reader);
        this.amplPlug = new MultiplyUnit();
        this.add(this.amplPlug);
        this.frequency = new SynthDistributor(this, "frequency");
        int i = 0;
        while (i < 10) {
            this.oscillators[i] = new TriangleOscillator();
            this.add(this.oscillators[i]);
            this.lags[i] = new ExponentialLag();
            this.add(this.lags[i]);
            this.mixers[i] = new BusWriter();
            this.add(this.mixers[i]);
            this.lags[i].halfLife.set(0.1 + 0.02 * (double)i);
            this.frequency.connect(this.lags[i].input);
            this.amplPlug.output.connect(this.oscillators[i].amplitude);
            this.lags[i].output.connect(this.oscillators[i].frequency);
            this.oscillators[i].output.connect(this.mixers[i].input);
            this.mixers[i].busOutput.connect(this.reader.busInput);
            ++i;
        }
        this.amplitude = this.amplPlug.inputA;
        this.addPort(this.amplitude, "amplitude");
        this.output = this.reader.output;
        this.addPort(this.output);
        this.amplPlug.inputB.set(0.1);
        this.amplitude.setup(0.0, 0.3, 0.999);
        this.frequency.setup(0.0, 800.0, 3000.0);
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        switch (stage) {
            case 0: {
                this.stop(time);
                this.start(time);
            }
        }
    }
}

