/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.Filter_2o2p2z;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.WhiteNoise;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.Tweakable;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class FilterLab
extends Applet
implements Tweakable {
    WhiteNoise noise;
    Filter_2o2p2z filter;
    LineOut myOut;
    TextField A0_Field;
    TextField A1_Field;
    TextField A2_Field;
    TextField B1_Field;
    TextField B2_Field;
    LabelledFader freqFader;
    LabelledFader widthFader;
    LabelledFader gainFader;
    Label omegaLabel;
    double omega = 0.0;
    double cs = 0.0;
    double sn = 0.0;
    double Q = 0.0;
    double alpha = 0.0;
    double A0_Value;
    double A1_Value;
    double A2_Value;
    double B1_Value;
    double B2_Value;
    double Freq_Value = 400.0;
    double Bandwidth_Value = 0.2;
    double Gain_Value = 0.0;
    Button useFieldsButton;
    Checkbox localBox;
    Choice filterChoice;
    static final int LOW_PASS = 0;
    static final int HIGH_PASS = 1;
    static final int BAND_PASS = 2;
    static final int PEAKING_EQ = 3;

    public static void main(String[] args) {
        FilterLab applet = new FilterLab();
        AppletFrame frame = new AppletFrame("Test JSyn Filter_2o2p2z", applet);
        frame.resize(700, 500);
        frame.show();
        frame.test();
    }

    void buildGUI() {
        this.setLayout(new GridLayout(0, 1));
        this.freqFader = new LabelledFader(this, 0, "Frequency", this.Freq_Value, 0.1, 10000.0);
        this.add(this.freqFader);
        this.widthFader = new LabelledFader(this, 1, "Bandwidth", this.Bandwidth_Value, 0.001, 0.5);
        this.add(this.widthFader);
        this.widthFader = new LabelledFader(this, 2, "dBGain", this.Gain_Value, -60.0, 30.0);
        this.add(this.widthFader);
        Panel subPanel = new Panel();
        this.add(subPanel);
        subPanel.setLayout(new FlowLayout(0));
        subPanel.add(new Label("A0:"));
        this.A0_Field = new TextField("0.0", 30);
        subPanel.add(this.A0_Field);
        subPanel = new Panel();
        this.add(subPanel);
        subPanel.setLayout(new FlowLayout(0));
        subPanel.add(new Label("A1:"));
        this.A1_Field = new TextField("0.0", 30);
        subPanel.add(this.A1_Field);
        subPanel = new Panel();
        this.add(subPanel);
        subPanel.setLayout(new FlowLayout(0));
        subPanel.add(new Label("A2:"));
        this.A2_Field = new TextField("0.0", 30);
        subPanel.add(this.A2_Field);
        subPanel = new Panel();
        this.add(subPanel);
        subPanel.setLayout(new FlowLayout(0));
        subPanel.add(new Label("B1:"));
        this.B1_Field = new TextField("0.0", 30);
        subPanel.add(this.B1_Field);
        subPanel = new Panel();
        this.add(subPanel);
        subPanel.setLayout(new FlowLayout(0));
        subPanel.add(new Label("B2:"));
        this.B2_Field = new TextField("0.0", 30);
        subPanel.add(this.B2_Field);
        this.omegaLabel = new Label("Internal values.");
        this.add(this.omegaLabel);
        subPanel = new Panel();
        this.add(subPanel);
        this.useFieldsButton = new Button("Use A & B fields.");
        subPanel.add(this.useFieldsButton);
        this.localBox = new Checkbox("Use local methods.");
        subPanel.add(this.localBox);
        this.filterChoice = new Choice();
        subPanel.add(this.filterChoice);
        this.filterChoice.addItem("LowPass");
        this.filterChoice.addItem("HighPass");
        this.filterChoice.addItem("BandPass");
        this.filterChoice.addItem("PeakingEQ");
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            this.noise = new WhiteNoise();
            this.filter = new Filter_2o2p2z();
            this.myOut = new LineOut();
            this.noise.output.connect(this.filter.input);
            this.filter.output.connect(this.myOut.input);
            this.buildGUI();
            this.noise.amplitude.set(0.2);
            this.updateFilter();
            this.noise.start();
            this.filter.start();
            this.myOut.start();
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void tweak(int targetIndex, double val) {
        switch (targetIndex) {
            case 0: {
                this.Freq_Value = val;
                break;
            }
            case 1: {
                this.Bandwidth_Value = val;
                break;
            }
            case 2: {
                this.Gain_Value = val;
            }
        }
        this.updateFilter();
    }

    void getNumbers() throws NumberFormatException {
        this.A0_Value = Double.valueOf(this.A0_Field.getText());
        this.A1_Value = Double.valueOf(this.A1_Field.getText());
        this.A2_Value = Double.valueOf(this.A2_Field.getText());
        this.B1_Value = Double.valueOf(this.B1_Field.getText());
        this.B2_Value = Double.valueOf(this.B2_Field.getText());
    }

    void updateCoefficientFields() {
        this.A0_Field.setText(Double.toString(this.A0_Value));
        this.A1_Field.setText(Double.toString(this.A1_Value));
        this.A2_Field.setText(Double.toString(this.A2_Value));
        this.B1_Field.setText(Double.toString(this.B1_Value));
        this.B2_Field.setText(Double.toString(this.B2_Value));
        this.omegaLabel.setText("omega = " + this.omega + ",  cos(omega) = " + this.cs + ",  Q = " + this.Q + ",  alpha = " + this.alpha);
    }

    void setFilterCoefficients() throws SynthException {
        this.filter.A0.set(this.A0_Value);
        this.filter.A1.set(this.A1_Value);
        this.filter.A2.set(this.A2_Value);
        this.filter.B1.set(this.B1_Value);
        this.filter.B2.set(this.B2_Value);
    }

    double sinh(double x) {
        return 0.5 * (Math.exp(x) - Math.exp(-x));
    }

    void calcCommon(double freq, double bandwidth) {
        double ratio = freq / Synth.getFrameRate();
        if (ratio >= 0.499) {
            ratio = 0.499;
        }
        this.omega = Math.PI * 2 * ratio;
        this.cs = Math.cos(this.omega);
        this.sn = Math.sin(this.omega);
        this.Q = this.sn / (Math.log(2.0) * bandwidth * this.omega);
        this.alpha = this.sn * this.sinh(0.5 / this.Q);
    }

    void lowPass(double freq, double bandwidth) {
        this.calcCommon(freq, bandwidth);
        double c0 = (1.0 - this.cs) * 0.5;
        double c1 = 1.0 - this.cs;
        double c2 = (1.0 - this.cs) * 0.5;
        double d0 = 1.0 + this.alpha;
        double d1 = -2.0 * this.cs;
        double d2 = 1.0 - this.alpha;
        double temp = 0.5 / d0;
        this.A0_Value = c0 * temp;
        this.A1_Value = c1 * temp;
        this.A2_Value = c2 * temp;
        this.B1_Value = d1 * temp;
        this.B2_Value = d2 * temp;
    }

    void highPass(double freq, double bandwidth) {
        this.calcCommon(freq, bandwidth);
        double c0 = (1.0 + this.cs) * 0.5;
        double c1 = -1.0 - this.cs;
        double c2 = (1.0 + this.cs) * 0.5;
        double d0 = 1.0 + this.alpha;
        double d1 = -2.0 * this.cs;
        double d2 = 1.0 - this.alpha;
        double temp = 0.5 / d0;
        this.A0_Value = c0 * temp;
        this.A1_Value = c1 * temp;
        this.A2_Value = c2 * temp;
        this.B1_Value = d1 * temp;
        this.B2_Value = d2 * temp;
    }

    void bandPass(double freq, double bandwidth) {
        this.calcCommon(freq, bandwidth);
        double c0 = this.alpha;
        double c1 = 0.0;
        double c2 = -this.alpha;
        double d0 = 1.0 + this.alpha;
        double d1 = -2.0 * this.cs;
        double d2 = 1.0 - this.alpha;
        double temp = 0.5 / d0;
        this.A0_Value = c0 * temp;
        this.A1_Value = c1 * temp;
        this.A2_Value = c2 * temp;
        this.B1_Value = d1 * temp;
        this.B2_Value = d2 * temp;
    }

    void updateFilter() {
        try {
            if (this.localBox.getState()) {
                switch (this.filterChoice.getSelectedIndex()) {
                    case 0: {
                        this.lowPass(this.Freq_Value, this.Bandwidth_Value);
                        break;
                    }
                    case 1: {
                        this.highPass(this.Freq_Value, this.Bandwidth_Value);
                        break;
                    }
                    case 2: {
                        this.bandPass(this.Freq_Value, this.Bandwidth_Value);
                    }
                }
                this.updateCoefficientFields();
                this.setFilterCoefficients();
            } else {
                switch (this.filterChoice.getSelectedIndex()) {
                    case 0: {
                        this.filter.lowPass(this.Freq_Value, this.Bandwidth_Value);
                        break;
                    }
                    case 1: {
                        this.filter.highPass(this.Freq_Value, this.Bandwidth_Value);
                        break;
                    }
                    case 2: {
                        this.filter.bandPass(this.Freq_Value, this.Bandwidth_Value);
                        break;
                    }
                    case 3: {
                        this.filter.peakingEQ(this.Freq_Value, this.Bandwidth_Value, this.Gain_Value);
                    }
                }
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        block4: {
            try {
                if (evt.target != this.useFieldsButton) break block4;
                this.getNumbers();
                this.setFilterCoefficients();
                return true;
            }
            catch (SynthException e) {
                SynthAlert.showError((Component)this, e);
                return true;
            }
        }
        if (evt.target == this.localBox || evt.target == this.filterChoice) {
            this.updateFilter();
            return true;
        }
        return false;
    }
}

