/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.examples.LongEcho;
import com.softsynth.jsyn.view11x.DecibelPortFader;
import com.softsynth.jsyn.view11x.PortFader;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;

public class TJ_Delay1
extends Applet {
    TriangleOscillator mySource;
    LineOut myOut;
    LongEcho myEcho;

    public static void main(String[] args) {
        TJ_Delay1 applet = new TJ_Delay1();
        AppletFrame frame = new AppletFrame("Test Sample", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.myEcho = new LongEcho(5.0);
            this.mySource = new TriangleOscillator();
            this.myOut = new LineOut();
            this.mySource.output.connect(this.myEcho.input);
            this.mySource.output.connect(0, this.myOut.input, 0);
            this.myEcho.output.connect(0, this.myOut.input, 1);
            this.add(new DecibelPortFader(this.mySource.amplitude, "source (dB)", -3.0, -60.0, 0.0));
            this.add(new PortFader(this.mySource.frequency, 0.0, 0.0, 3000.0));
            this.add(new PortFader(this.myEcho.feedback, -0.9, -1.0, 0.0));
            this.add(new DecibelPortFader(this.myEcho.amplitude, "echo (dB)", -3.0, -60.0, 0.0));
            this.myOut.start();
            this.myEcho.start();
            this.mySource.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.mySource.stop();
            this.myEcho.stop();
            this.myOut.stop();
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

