/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.tools.view.JAppletFrame;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;

public class TJ_Env1
extends JApplet {
    SynthEnvelope sgEnvData;
    EnvelopePlayer sgEnv;
    SineOscillator sgOsc;
    LineOut sgOut;
    int numFrames;
    final int MAX_FRAMES = 16;
    double[] data = new double[32];
    JButton hitme;
    JButton attackButton;
    JButton releaseButton;

    public static void main(String[] args) {
        TJ_Env1 applet = new TJ_Env1();
        JAppletFrame frame = new JAppletFrame("Test SynthEnvelope", applet);
        frame.setSize(440, 200);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            int i = 0;
            this.data[i++] = 0.02;
            this.data[i++] = 1.0;
            this.data[i++] = 0.4;
            this.data[i++] = 0.4;
            this.data[i++] = 0.9;
            this.data[i++] = 0.0;
            this.numFrames = i / 2;
            this.sgEnvData = new SynthEnvelope(this.data);
            this.sgEnv = new EnvelopePlayer();
            this.sgOsc = new SineOscillator();
            this.sgOut = new LineOut();
            this.sgEnv.output.connect(0, this.sgOsc.amplitude, 0);
            this.sgOsc.output.connect(0, this.sgOut.input, 0);
            this.sgOsc.output.connect(0, this.sgOut.input, 1);
            this.hitme = new JButton("Hit");
            this.add(this.hitme);
            this.hitme.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Env1.this.sgEnv.envelopePort.queue(TJ_Env1.this.sgEnvData, 0, TJ_Env1.this.numFrames);
                }
            });
            this.attackButton = new JButton("Attack");
            this.add(this.attackButton);
            this.attackButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Env1.this.sgEnv.envelopePort.queue(TJ_Env1.this.sgEnvData, 0, TJ_Env1.this.numFrames - 1);
                }
            });
            this.releaseButton = new JButton("Release");
            this.add(this.releaseButton);
            this.releaseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Env1.this.sgEnv.envelopePort.queue(TJ_Env1.this.sgEnvData, TJ_Env1.this.numFrames - 1, 1);
                }
            });
            this.add(new ExponentialPortFader(this.sgOsc.frequency, 400.0, 50.0, 2000.0));
            this.sgOut.start();
            this.sgOsc.start();
            this.sgEnv.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.sgOut.delete();
            this.sgOut = null;
            this.sgOsc.delete();
            this.sgOsc = null;
            this.sgEnv.delete();
            this.sgEnv = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

