/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineIn;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.SynthScope;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class TJ_Oscilloscope
extends Applet
implements ItemListener {
    LineIn lineIn;
    LineOut lineOut;
    SynthScope scope;
    SynthContext synthContext;
    Checkbox echoBox;

    public static void main(String[] args) {
        TJ_Oscilloscope applet = new TJ_Oscilloscope();
        AppletFrame frame = new AppletFrame("Oscilloscope", applet);
        frame.resize(600, 500);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            Synth.requestVersion(142);
            this.synthContext = new SynthContext();
            try {
                this.synthContext.startEngine(32);
                this.lineOut = new LineOut(this.synthContext);
                this.echoBox = new Checkbox("Echo Input to Output", false);
                this.add("North", this.echoBox);
                this.echoBox.addItemListener(this);
            }
            catch (SynthException e) {
                this.synthContext.startEngine(96);
            }
            this.lineIn = new LineIn(this.synthContext);
            if (this.lineOut != null) {
                this.lineIn.output.connect(0, this.lineOut.input, 0);
                this.lineIn.output.connect(1, this.lineOut.input, 1);
            }
            this.scope = new SynthScope(this.synthContext, 2048);
            this.scope.createProbe(this.lineIn.output, 0, "Left", Color.red);
            this.scope.createProbe(this.lineIn.output, 1, "Right", Color.blue);
            this.scope.finish();
            this.scope.getWaveDisplay().setBackground(Color.white);
            this.scope.getWaveDisplay().setForeground(Color.black);
            this.add("Center", this.scope);
            this.getParent().validate();
            this.getToolkit().sync();
            this.lineIn.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        this.removeAll();
        try {
            this.lineIn.delete();
            if (this.lineOut != null) {
                this.lineOut.delete();
            }
            this.lineOut = null;
            this.synthContext.stopEngine();
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getID() == 701) {
            if (this.echoBox.getState()) {
                this.lineOut.start();
            } else {
                this.lineOut.stop();
            }
        }
    }
}

