/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.perfrack;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.RingModBell;
import com.softsynth.jsyn.examples.perfrack.SimpleRackUnit;
import com.softsynth.jsyn.view102.BarGraphEditor;
import com.softsynth.jsyn.view102.CheckboxPanel;
import com.softsynth.jsyn.view102.InsetPanel;
import com.softsynth.jsyn.view102.PortFader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;

class BellPatternRackUnit
extends SimpleRackUnit {
    static final int NUM_BOXES = 16;
    static final int BOXES_PER_BEAT = 2;
    Panel panel;
    CheckboxPanel cbPanel;
    RingModBell bell;
    BarGraphEditor freqEditor;
    double[] freqData;

    public BellPatternRackUnit() {
        this.setName("Ring Mod Bell");
        try {
            this.bell = new RingModBell();
            this.unitNote = this.bell;
            this.unitNote.amplitude.set(0.5);
            this.bell.halfLife.set(0.02);
        }
        catch (SynthException e) {
            System.err.println("Error in BellPatternRackUnit" + e);
            return;
        }
        this.numRackUnits = 3;
        this.setLayout(new BorderLayout());
        this.cbPanel = new CheckboxPanel(16);
        InsetPanel insetPanel = new InsetPanel((Component)this.cbPanel, Color.green);
        this.add("North", insetPanel);
        this.cbPanel.getNthBox(0).setState(true);
        this.cbPanel.getNthBox(8).setState(true);
        this.freqData = new double[16];
        int i = 0;
        while (i < this.freqData.length) {
            this.freqData[i] = 1120.0;
            ++i;
        }
        this.freqEditor = new BarGraphEditor(this.freqData);
        insetPanel = new InsetPanel((Component)this.freqEditor, Color.yellow);
        this.add("Center", insetPanel);
        this.freqEditor.setBackground(Color.white);
        this.freqEditor.setMinWorldY(100.0);
        this.freqEditor.setMaxWorldY(4000.0);
        this.add("South", new PortFader(this.bell.modIndex, 0.26, 0.0, 1.0));
    }

    @Override
    public void beat(int time, int duration, int beatIndex) throws SynthException {
        int boxIndex = beatIndex * 2 % 16;
        this.freqEditor.highlight(boxIndex);
        this.cbPanel.highlight(boxIndex);
        int i = 0;
        while (i < 2) {
            if (this.cbPanel.getNthBox(boxIndex).getState()) {
                this.bell.setStage(time, 0);
                this.bell.frequency.set(time, this.freqData[boxIndex]);
            }
            time += duration / 2;
            ++boxIndex;
            ++i;
        }
    }
}

