/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.perfrack;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.LagFilteredNoise;
import com.softsynth.jsyn.examples.perfrack.SimpleRackUnit;
import com.softsynth.jsyn.view102.BarGraphEditor;
import com.softsynth.jsyn.view102.InsetPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;

class NoiseContourRackUnit
extends SimpleRackUnit {
    static final int NUM_BOXES = 32;
    static final int BOXES_PER_BEAT = 4;
    Panel panel;
    LagFilteredNoise lagNoise;
    BarGraphEditor ampEditor;
    double[] ampData;
    BarGraphEditor freqEditor;
    double[] freqData;

    public NoiseContourRackUnit() {
        this.setName("Filtered Noise");
        try {
            this.lagNoise = new LagFilteredNoise();
            this.unitNote = this.lagNoise;
            this.unitNote.amplitude.set(0.3);
            this.lagNoise.resonance.set(0.02);
        }
        catch (SynthException e) {
            System.err.println("Error in NoiseContourRackUnit" + e);
            return;
        }
        this.numRackUnits = 3;
        this.setLayout(new GridLayout(0, 1));
        this.ampData = new double[32];
        this.ampEditor = new BarGraphEditor(this.ampData);
        this.ampEditor.setBackground(Color.white);
        InsetPanel insetPanel = new InsetPanel((Component)this.ampEditor, Color.green);
        this.add(insetPanel);
        this.freqData = new double[32];
        int i = 0;
        while (i < this.freqData.length) {
            this.freqData[i] = 400.0;
            ++i;
        }
        this.freqEditor = new BarGraphEditor(this.freqData);
        this.freqEditor.setBackground(Color.white);
        insetPanel = new InsetPanel((Component)this.freqEditor, Color.yellow);
        this.add(insetPanel);
        this.freqEditor.setMinWorldY(60.0);
        this.freqEditor.setMaxWorldY(1400.0);
        this.ampData[8] = 0.8;
        this.freqData[8] = 1000.0;
    }

    @Override
    public void beat(int time, int duration, int beatIndex) throws SynthException {
        double lagTime = (double)duration / (4.0 * Synth.getTickRate());
        this.lagNoise.amplitudeTime.set(lagTime);
        this.lagNoise.frequencyTime.set(lagTime);
        int boxIndex = beatIndex * 4 % 32;
        this.ampEditor.highlight(boxIndex);
        this.freqEditor.highlight(boxIndex);
        int i = 0;
        while (i < 4) {
            this.lagNoise.amplitudeTarget.set(time, this.ampData[i + boxIndex]);
            this.lagNoise.frequency.set(time, this.freqData[i + boxIndex]);
            time += duration / 4;
            ++i;
        }
    }
}

