/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import java.applet.Applet;
import java.awt.Component;

public class QA_Envelopes
extends Applet {
    EnvelopePlayer player;
    boolean showAlerts = false;
    int numErrors = 0;

    public static void main(String[] args) {
        QA_Envelopes applet = new QA_Envelopes();
        AppletFrame frame = new AppletFrame("QA Envelopes", applet);
        frame.resize(600, 500);
        frame.show();
        frame.test();
    }

    void reportError(String msg) {
        System.err.println(msg);
        ++this.numErrors;
    }

    @Override
    public void start() {
        block6: {
            try {
                Synth.startEngine(0);
                this.player = new EnvelopePlayer();
                try {
                    this.player.envelopePort.queue(null, 0, 2, 0);
                    ++this.numErrors;
                    System.err.println("ERROR - didn't catch null envelope.");
                }
                catch (NullPointerException e) {
                    System.out.println("Correctly caught null envelope.");
                }
                try {
                    this.player.envelopePort.queue(new SynthEnvelope(0));
                    ++this.numErrors;
                    System.err.println("ERROR - didn't catch empty envelope.");
                }
                catch (SynthException e) {
                    System.out.println("Correctly caught empty envelope.");
                }
            }
            catch (SynthException e) {
                if (!this.showAlerts) break block6;
                SynthAlert.showError((Component)this, e);
            }
        }
    }

    @Override
    public void stop() {
        Synth.stopEngine();
        System.out.println("NumErrors = " + this.numErrors);
    }
}

