/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.UsageDisplay;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Label;
import java.util.Vector;

public class QA_ManySines
extends Applet {
    Vector mySines;
    Vector myOutputs;
    Button startOne;
    Button stopOne;
    Label showNumNoodlers;

    public static void main(String[] args) {
        QA_ManySines applet = new QA_ManySines();
        AppletFrame frame = new AppletFrame("Test JSyn", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            this.mySines = new Vector();
            this.myOutputs = new Vector();
            this.startOne = new Button("StartAnother");
            this.add(this.startOne);
            this.stopOne = new Button("StopOne");
            this.add(this.stopOne);
            this.add(new UsageDisplay());
            this.showNumNoodlers = new Label("Num = 0");
            this.add(this.showNumNoodlers);
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void updateCount() {
        this.showNumNoodlers.setText("Num = " + this.myOutputs.size());
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void stopVoice() {
        try {
            int numNoodlers = this.myOutputs.size();
            if (numNoodlers == 0) {
                return;
            }
            int noodlerVictim = numNoodlers - 1;
            SineOscillator sine = (SineOscillator)this.mySines.elementAt(noodlerVictim);
            sine.stop();
            this.mySines.removeElement(sine);
            LineOut outunit = (LineOut)this.myOutputs.elementAt(noodlerVictim);
            outunit.stop();
            this.myOutputs.removeElement(outunit);
            this.updateCount();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void startVoice() {
        try {
            SineOscillator sine = new SineOscillator();
            this.mySines.addElement(sine);
            int numNoodlers = this.myOutputs.size();
            sine.frequency.set(100.0 + (double)numNoodlers * 25.0);
            sine.amplitude.set(0.05);
            LineOut outunit = new LineOut();
            this.myOutputs.addElement(outunit);
            sine.output.connect(0, outunit.input, 0);
            sine.output.connect(0, outunit.input, 1);
            sine.start();
            outunit.start();
            this.updateCount();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.startOne) {
            this.startVoice();
            return true;
        }
        if (evt.target == this.stopOne) {
            this.stopVoice();
            return true;
        }
        return false;
    }
}

