/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.view102.SynthProbe;
import com.softsynth.jsyn.view102.SynthProbeCircuit;
import com.softsynth.jsyn.view102.SynthScopeProbePanel;
import com.softsynth.jsyn.view102.UsageDisplay;
import com.softsynth.jsyn.view102.WaveDisplay;
import com.softsynth.jsyn.view102.WaveTrace;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Panel;

public class InternalSynthScope
extends Panel
implements Runnable {
    SynthProbeCircuit probeCircuit;
    WaveDisplay waveDisplay;
    Thread autoThread;
    boolean runAuto = false;
    boolean autoEnable;
    double autoRate;
    int sampleSize;
    SynthContext synthContext;
    protected Button captureButton;
    protected Checkbox autoBox;
    protected Button zoomInButton;
    protected Button zoomOutButton;
    protected Button panLeftButton;
    protected Button panRightButton;
    Panel controlPanel;
    Panel buttonPanel;

    public InternalSynthScope(SynthContext synthContext, int sampleSize) {
        this.sampleSize = sampleSize;
        this.synthContext = synthContext;
        this.setCaptureRate(1.0);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraint = new GridBagConstraints();
        this.setLayout(gridbag);
        constraint.gridwidth = 0;
        constraint.fill = 1;
        constraint.weightx = 1.0;
        this.waveDisplay = new WaveDisplay();
        this.add(this.waveDisplay);
        this.waveDisplay.setBackground(Color.black);
        constraint.gridheight = -1;
        constraint.weighty = 1.0;
        gridbag.setConstraints(this.waveDisplay, constraint);
        constraint.weighty = 0.0;
        this.controlPanel = new Panel();
        constraint.gridheight = 0;
        gridbag.setConstraints(this.controlPanel, constraint);
        this.controlPanel.setLayout(new GridLayout(0, 1));
        this.buttonPanel = new Panel();
        this.controlPanel.add(this.buttonPanel);
        this.captureButton = new Button("Capture");
        this.buttonPanel.add(this.captureButton);
        this.autoBox = new Checkbox("Auto");
        this.buttonPanel.add(this.autoBox);
        this.autoBox.setState(false);
        this.zoomInButton = new Button("Zoom In");
        this.buttonPanel.add(this.zoomInButton);
        this.zoomOutButton = new Button("Zoom Out");
        this.buttonPanel.add(this.zoomOutButton);
        this.panLeftButton = new Button("<<<");
        this.buttonPanel.add(this.panLeftButton);
        this.panRightButton = new Button(">>>");
        this.buttonPanel.add(this.panRightButton);
        this.buttonPanel.add(new UsageDisplay(synthContext));
        this.probeCircuit = new SynthProbeCircuit(synthContext, sampleSize);
        this.showControls();
    }

    public void finish(boolean autoEnabled) {
        this.probeCircuit.compile();
        this.autoBox.setState(autoEnabled);
        this.autoBox.repaint();
        this.handleAutoBox();
    }

    public void finish() {
        this.finish(true);
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.autoEnable) {
                    this.capture();
                }
                Thread.sleep((int)(1000.0 / this.autoRate));
            }
        }
        catch (InterruptedException e) {
        }
        catch (SynthException e) {
            System.out.println("SynthScope caught " + e);
        }
        this.autoThread = null;
    }

    public void addProbe(SynthScopeProbePanel probePanel) throws SynthException {
        probePanel.useDisplay(this.waveDisplay);
        this.controlPanel.add(probePanel);
        this.repaint();
    }

    public void removeProbe(SynthScopeProbePanel probePanel) throws SynthException {
        probePanel.useDisplay(null);
        this.controlPanel.remove(probePanel);
        this.repaint();
    }

    public SynthScopeProbePanel createProbe(SynthOutput outPort, int partNum, String name, Color color) {
        SynthProbe probe = this.probeCircuit.addProbe(outPort, partNum);
        WaveTrace trace = new WaveTrace(probe.data, color, 1.0);
        SynthScopeProbePanel probePanel = new SynthScopeProbePanel(trace, name);
        this.addProbe(probePanel);
        return probePanel;
    }

    public SynthScopeProbePanel createProbe(SynthOutput outPort, String name, Color color) {
        return this.createProbe(outPort, 0, name, color);
    }

    public void showControls() {
        this.remove(this.controlPanel);
        this.add(this.controlPanel);
        this.validate();
    }

    public void hideControls() {
        this.remove(this.controlPanel);
        this.validate();
    }

    public void setCaptureRate(double capturesPerSecond) {
        if (capturesPerSecond > 30.0) {
            capturesPerSecond = 30.0;
        }
        this.autoRate = capturesPerSecond;
    }

    public double getCaptureRate() {
        return this.autoRate;
    }

    public synchronized void capture() {
        this.probeCircuit.trigger();
        this.synthContext.sleepForTicks(this.sampleSize / this.synthContext.getFramesPerTick() + 1);
        this.probeCircuit.readData();
        this.waveDisplay.repaint();
    }

    protected void handleAutoBox() {
        if (this.autoBox.getState()) {
            this.autoEnable = true;
            if (this.autoThread == null) {
                this.autoThread = new Thread(this);
                this.autoThread.start();
            }
        } else {
            this.autoEnable = false;
        }
    }

    protected boolean handleButtonAction(Component source) {
        if (source == this.captureButton) {
            this.capture();
            return true;
        }
        if (source == this.autoBox) {
            this.handleAutoBox();
            return true;
        }
        if (source == this.zoomInButton) {
            this.waveDisplay.zoomIn();
            this.waveDisplay.repaint();
            return true;
        }
        if (source == this.zoomOutButton) {
            this.waveDisplay.zoomOut();
            this.waveDisplay.repaint();
            return true;
        }
        if (source == this.panLeftButton) {
            this.waveDisplay.panLeft();
            this.waveDisplay.repaint();
            return true;
        }
        if (source == this.panRightButton) {
            this.waveDisplay.panRight();
            this.waveDisplay.repaint();
            return true;
        }
        return false;
    }

    public WaveDisplay getWaveDisplay() {
        return this.waveDisplay;
    }
}

