/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.midifile;

import com.softsynth.midifile.MIDIFileInputStream;
import com.softsynth.midifile.MIDIFileListener;
import com.softsynth.midifile.MIDIStandard;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MIDIFilePrinter
implements MIDIFileListener {
    @Override
    public void handleHeader(int format, int numTracks, short division) {
        System.out.println("MIDI File Format " + format + ", numTracks = " + numTracks + ", division = " + division);
    }

    @Override
    public void handleBeginTrack(int index) {
        System.out.println("MIDI Track " + index + " Beginning");
    }

    @Override
    public void handleEndTrack(int index) {
        System.out.println("MIDI Track " + index + " Ending");
    }

    @Override
    public void handleSysExF0(int ticks, byte[] b) {
        System.out.println("Sysex F0 Event at " + ticks);
    }

    @Override
    public void handleSysExF7(int ticks, byte[] b) {
        System.out.println("Sysex F0 Event at " + ticks);
    }

    @Override
    public void handleMetaEvent(int ticks, int type, byte[] b) {
        System.out.print("Meta Event at " + ticks + ", type = " + type);
        if (b != null) {
            System.out.print(", len = " + b.length);
            if (type >= 1 && type <= 7) {
                System.out.print(", " + new String(b));
            }
        }
        System.out.println("");
    }

    @Override
    public void handleEvent(int ticks, int command, int data1, int data2) {
        System.out.println("MIDI Event at " + ticks + ", " + MIDIStandard.messageToString(command, data1, data2));
    }

    public static void main(String[] args) {
        System.out.println("=============================================");
        MIDIFilePrinter.printMIDIFile(args[0]);
    }

    public static void printMIDIFile(String fileName) {
        try {
            try {
                FileInputStream stream = new FileInputStream(fileName);
                MIDIFileInputStream parser = new MIDIFileInputStream(stream);
                MIDIFilePrinter printer = new MIDIFilePrinter();
                parser.addMIDIFileListener(printer);
                parser.parse();
                parser.close();
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
            }
            catch (SecurityException e) {
                System.err.println(e);
            }
        }
        catch (IOException e) {
            System.err.println("Caught " + e);
            e.printStackTrace();
        }
    }
}

