/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreInstrument;

public abstract class ScoreElementPlayer {
    private ScoreElementPlayer parent;
    private ScoreElement element;
    private double amplitude = 1.0;
    private ScoreInstrument instrument;

    public ScoreElementPlayer(ScoreElement element, ScoreElementPlayer parent) {
        this.element = element;
        this.parent = parent;
        this.updateAmplitude();
    }

    public void start(double time) {
        this.updateAmplitude();
    }

    public void updateAmplitude() {
        this.amplitude = this.element.getAmplitude();
        if (this.parent != null) {
            this.amplitude *= this.parent.getAmplitude();
        }
        this.instrument = this.element.getInstrument();
        if (this.instrument == null && this.parent != null) {
            this.instrument = this.parent.getInstrumentFromTree();
        }
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public ScoreElementPlayer getParent() {
        return this.parent;
    }

    public ScoreElement getElement() {
        return this.element;
    }

    public ScoreInstrument getInstrument() {
        return this.instrument;
    }

    public ScoreInstrument getInstrumentFromTree() {
        if (this.instrument == null && this.parent != null) {
            return this.parent.getInstrumentFromTree();
        }
        return this.instrument;
    }

    public abstract boolean isDone();

    public abstract double advance(double var1);
}

