/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.support;

import com.softsynth.support.CheckJSyn;
import com.softsynth.support.TextAreaOutputStream;
import com.softsynth.support.WriteCGI;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class QuickCheck
extends Applet {
    TextArea textArea;
    TextAreaOutputStream textOut;
    PrintStream out;
    boolean isApplet = true;
    boolean jsynOK = false;

    public static void main(String[] args) {
        QuickCheck applet = new QuickCheck();
        applet.isApplet = false;
        Frame f = new Frame("Applet Frame");
        f.add("Center", applet);
        applet.init();
        applet.start();
        f.setSize(600, 350);
        f.show();
    }

    @Override
    public void start() {
        String agent = null;
        this.setLayout(new BorderLayout());
        this.textArea = new TextArea();
        this.textOut = new TextAreaOutputStream(this.textArea);
        this.out = new PrintStream(this.textOut);
        this.add("Center", this.textArea);
        this.getParent().validate();
        this.getToolkit().sync();
        StringBuffer buf = new StringBuffer();
        this.out.println("Test the JSyn Plugin (QC build #2)");
        CheckJSyn checker = new CheckJSyn();
        int result = checker.checkInstallation(this.out);
        if (result == 0) {
            buf.append("SUCCESS, 0");
            this.jsynOK = true;
        } else {
            buf.append("ERROR, " + result);
        }
        try {
            agent = this.getParameter("userAgent");
        }
        catch (Exception e) {
            System.out.println("Parameter userAgent not available.");
        }
        if (agent == null) {
            agent = "noscript";
        }
        agent = this.replaceChars(agent, ',', ' ');
        buf.append(", " + agent);
        System.out.println("InternetExplorer may report an internal Exception here. It's OK.");
        try {
            String ipAddress = InetAddress.getLocalHost().toString();
            buf.append(", " + ipAddress);
        }
        catch (UnknownHostException e) {
            buf.append(", unknown");
        }
        catch (SecurityException e) {
            buf.append(", unavailable");
        }
        buf.append(", " + this.getProp("java.version"));
        String vendor = this.getProp("java.vendor");
        vendor = this.replaceChars(vendor, ',', ' ');
        buf.append(", " + vendor);
        buf.append(", " + this.getProp("os.name"));
        buf.append(", " + this.getProp("os.arch"));
        buf.append(", " + this.getProp("os.version"));
        buf.append("\n");
        if (result < 0) {
            this.out.println("Please try restarting your browser.");
            this.out.println("If that doesn't work, try restarting your computer.");
            this.out.println("If that doesn't work, try reinstalling the JSyn plugin.");
            this.out.println("If that doesn't work, please contact us.");
        } else {
            this.out.println("The JSyn Plugin was successfully installed. Please continue.\n");
        }
        String report = buf.toString();
        try {
            WriteCGI.writeMessage("www.softsynth.com", "append_jsplog.cgi", report);
        }
        catch (Exception e) {
            System.err.println("JSyn QuickCheck could not log report but that's OK.");
        }
    }

    String getProp(String key) {
        String value;
        try {
            value = System.getProperty(key);
            if (value == null) {
                value = "UNDEFINED";
            }
        }
        catch (SecurityException e) {
            value = "UNAVAILABLE";
        }
        return value;
    }

    String replaceChars(String text, char oldChar, char newChar) {
        StringBuffer buf = new StringBuffer(text);
        int i = 0;
        while (i < text.length()) {
            if (buf.charAt(i) == oldChar) {
                buf.setCharAt(i, newChar);
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public void stop() {
        this.removeAll();
    }
}

