/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.tools.view;

import com.softsynth.view.ValueController;
import com.softsynth.view.ValueEvent;
import com.softsynth.view.ValueListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class RotaryKnob
extends Canvas
implements MouseListener,
MouseMotionListener,
ValueController {
    public static final int LINEAR = 0;
    public static final int EXPONENTIAL = 1;
    int taper = 0;
    Vector listeners = new Vector();
    ValueEvent event = new ValueEvent(this);
    double minAngle = -2.827433388230814;
    double maxAngle = 2.827433388230814;
    double minVal;
    double maxVal;
    double logMax;
    double logMin;
    double fraction;
    double value;
    double unitIncrement = 0.01;
    int lastY;
    int diameter;
    int radius;
    int x0;
    int y0;

    public RotaryKnob(double val, double min, double max) {
        this.setValues(val, min, max);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void addValueListener(ValueListener listener) {
        this.listeners.addElement(listener);
    }

    @Override
    public void removeValueListener(ValueListener listener) {
        this.listeners.removeElement(listener);
    }

    public void setTaper(int taper) {
        this.taper = taper;
        this.setValue(this.value);
    }

    public int getTaper() {
        return this.taper;
    }

    private void internalSetValue(double v) {
        this.value = v;
        this.tellListeners();
        Graphics g = this.getGraphics();
        if (g != null) {
            this.drawKnob(g);
        }
    }

    @Override
    public void setValue(double v) {
        if (v < this.minVal) {
            v = this.minVal;
        } else if (v > this.maxVal) {
            v = this.maxVal;
        }
        this.fraction = this.valueToFraction(v);
        this.internalSetValue(v);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    void setFraction(double frac) {
        this.fraction = frac < 0.0 ? 0.0 : (frac > 1.0 ? 1.0 : frac);
        this.internalSetValue(this.fractionToValue(this.fraction));
    }

    public void setValues(double val, double min, double max) {
        this.value = val;
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValue(val);
    }

    @Override
    public void setMaximum(double maximum) {
        this.maxVal = maximum;
        this.logMax = Math.log(maximum);
        this.setValue(this.value);
    }

    @Override
    public double getMaximum() {
        return this.maxVal;
    }

    @Override
    public void setMinimum(double minimum) {
        this.minVal = minimum;
        this.logMin = Math.log(minimum);
        this.setValue(this.value);
    }

    @Override
    public double getMinimum() {
        return this.minVal;
    }

    public void setUnitIncrement(double v) {
        this.unitIncrement = v;
    }

    public double getUnitIncrement() {
        return this.unitIncrement;
    }

    private void tellListeners() {
        Enumeration e = this.listeners.elements();
        this.event.setValue(this.value);
        while (e.hasMoreElements()) {
            ValueListener listener = (ValueListener)e.nextElement();
            listener.valueChanged(this.event);
        }
    }

    double valueToFraction(double val) {
        double result = 0.0;
        switch (this.taper) {
            case 0: {
                result = (val - this.minVal) / (this.maxVal - this.minVal);
                break;
            }
            case 1: {
                result = (Math.log(val) - this.logMin) / (this.logMax - this.logMin);
            }
        }
        return result;
    }

    double fractionToValue(double frac) {
        double result = 0.0;
        switch (this.taper) {
            case 0: {
                result = frac * (this.maxVal - this.minVal) + this.minVal;
                break;
            }
            case 1: {
                double exp = frac * (this.logMax - this.logMin);
                result = this.minVal * Math.exp(exp);
            }
        }
        return result;
    }

    protected void setKnobByXY(int x, int y) {
        int xdiff = this.x0 - x;
        double power = (double)xdiff / (double)this.radius;
        double perPixel = this.unitIncrement * Math.pow(2.0, power);
        int ydiff = this.lastY - y;
        this.setFraction(this.fraction + (double)ydiff * perPixel);
        this.lastY = y;
    }

    protected void handleMousePressed(boolean isShiftDown, int x, int y) {
        this.lastY = y;
        this.setKnobByXY(x, y);
    }

    protected void handleMouseDragged(int x, int y) {
        this.setKnobByXY(x, y);
    }

    protected void handleMouseReleased(int x, int y) {
        this.setKnobByXY(x, y);
    }

    private double fractionToAngle(double fraction) {
        return fraction * (this.maxAngle - this.minAngle) + this.minAngle;
    }

    void drawLineIndicator(Graphics g) {
        double angle = this.fractionToAngle(this.fraction);
        double arrowSize = (double)this.radius * 0.95;
        int arrowX = (int)(arrowSize * Math.sin(angle));
        int arrowY = (int)(arrowSize * Math.cos(angle));
        g.setColor(Color.red);
        g.drawLine(this.x0, this.y0, this.x0 + arrowX, this.y0 - arrowY);
        double dotScale = 0.1;
        int dotRadius = (int)(dotScale * arrowSize);
        if (dotRadius > 1) {
            int dotX = this.x0 + (int)((0.99 - dotScale) * (double)arrowX) - dotRadius;
            int dotY = this.y0 - (int)((0.99 - dotScale) * (double)arrowY) - dotRadius;
            g.fillOval(dotX, dotY, dotRadius * 2, dotRadius * 2);
        }
    }

    void drawPolyIndicator(Graphics g) {
        int arrowSize = (int)((double)this.radius * 0.95);
        int arrowWidth = (int)((double)this.radius * 0.2);
        int[] nArray = new int[4];
        nArray[1] = arrowWidth;
        nArray[3] = -arrowWidth;
        int[] xp = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = arrowSize;
        nArray2[1] = -arrowSize / 2;
        nArray2[3] = -arrowSize / 2;
        int[] yp = nArray2;
        double angle = this.fractionToAngle(this.fraction);
        double sa = Math.sin(angle);
        double ca = Math.cos(angle);
        int i = 0;
        while (i < xp.length) {
            int x = xp[i];
            int y = yp[i];
            xp[i] = this.x0 - (int)((double)x * ca - (double)y * sa);
            yp[i] = this.y0 - (int)((double)x * sa + (double)y * ca);
            ++i;
        }
        g.setColor(this.isEnabled() ? Color.red : Color.red.darker());
        g.fillPolygon(xp, yp, xp.length);
    }

    void drawKnob(Graphics g) {
        g.setColor(Color.lightGray);
        g.fillOval(this.x0 - this.radius, this.y0 - this.radius, this.diameter, this.diameter);
        this.drawPolyIndicator(g);
    }

    @Override
    public void paint(Graphics g) {
        int width = this.bounds().width;
        int height = this.bounds().height;
        this.x0 = width / 2;
        this.y0 = height / 2;
        this.diameter = width < height ? width : height;
        this.diameter -= 4;
        this.radius = this.diameter / 2;
        g.setColor(Color.darkGray);
        g.fillOval(this.x0 - this.radius + 2, this.y0 - this.radius + 2, this.diameter, this.diameter);
        this.drawKnob(g);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleMouseDragged(e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleMousePressed(e.isShiftDown(), e.getX(), e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleMouseReleased(e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

