/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.tools.view;

import com.softsynth.util.NumericOutput;
import java.awt.Color;
import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class TextFieldDouble
extends TextField {
    boolean modified = false;
    int numCharacters;

    public TextFieldDouble(double val, int numCharacters) {
        super(numCharacters);
        this.setValue(val);
        this.numCharacters = numCharacters;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TextFieldDouble.this.markDirty();
            }
        });
    }

    private void markDirty() {
        this.modified = true;
        this.setBackground(Color.pink);
        this.repaint();
    }

    private void markClean() {
        this.modified = false;
        this.setBackground(Color.white);
        this.repaint();
    }

    @Override
    public void setText(String text) {
        this.markDirty();
        super.setText(text);
    }

    public double getValue() throws NumberFormatException {
        double val = Double.valueOf(this.getText());
        this.markClean();
        return val;
    }

    public void setValue(double value) {
        super.setText(NumericOutput.doubleToString(value, 1, 4));
        this.markClean();
    }
}

