/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.wire.DraggableCanvas;
import com.softsynth.wire.Module;
import com.softsynth.wire.SaveAsStream;
import com.softsynth.wire.WireJack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class Comment
extends Module {
    JTextArea textArea;

    Comment() {
    }

    @Override
    void addDragger() {
        this.panel.setLayout(new BorderLayout());
        this.calculateSize();
        this.dragger = new DraggableCanvas("Comment");
        this.panel.add((Component)this.dragger, "North");
        this.dragger.setPreferredSize(new Dimension(25, 18));
        this.dragger.setWireJack(new WireJack(this, this.dragger, this.getName()));
        this.dragger.getWireJack().setDragged(this);
        this.dragger.addMouseListener(this.patch.getPatchPanel());
        this.dragger.addMouseMotionListener(this.patch.getPatchPanel());
    }

    @Override
    public void setComment(String text) {
        super.setComment(text);
        this.textArea.setText(text);
    }

    public String getComment(String text) {
        return this.textArea.getText();
    }

    @Override
    public void calculateSize() {
        this.panel.setSize(200, 200);
    }

    @Override
    public void setupJacks() {
        this.textArea = new JTextArea("Type in here...", 4, 20);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.panel.add((Component)scrollPane, "Center");
    }

    @Override
    String getTagName() {
        return "misc";
    }

    @Override
    public void saveContentToStream(SaveAsStream stream) throws IOException {
        stream.writeComment(this.textArea.getText());
    }
}

