/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.util.TextOutput;
import com.softsynth.wire.Module;
import com.softsynth.wire.SynthWireJack;
import com.softsynth.wire.VariableSynthWireJack;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireJack;

class InputSynthWireJack
extends VariableSynthWireJack {
    public InputSynthWireJack(Module module, String name, SynthPort port) {
        super(module, name, port);
    }

    @Override
    void setup() {
        super.setup();
        this.comp.setBackground(Wire.CONNECT_PORT_COLOR);
        this.orSupportMask(2);
    }

    @Override
    public void halfDisconnect(WireJack other) {
        super.halfDisconnect(other);
        try {
            if (this.getSynthPort() instanceof SynthDistributor) {
                ((SynthDistributor)this.getSynthPort()).disconnect();
            } else {
                ((SynthInput)this.getSynthPort()).disconnect(this.partIndex);
            }
        }
        catch (SynthException synthException) {
            // empty catch block
        }
    }

    @Override
    public void halfConnect(WireJack other) {
        super.halfConnect(other);
        if (other instanceof SynthWireJack) {
            SynthWireJack source = (SynthWireJack)other;
            SynthInput thisInput = (SynthInput)this.port;
            try {
                if (source.getSynthPort() instanceof SynthOutput) {
                    ((SynthOutput)source.getSynthPort()).connect(source.getPartIndex(), thisInput, this.getPartIndex());
                } else if (source.getSynthPort() instanceof SynthDistributor) {
                    ((SynthDistributor)source.getSynthPort()).connect(thisInput, this.getPartIndex());
                }
            }
            catch (SynthException e) {
                TextOutput.println("Connect error: " + e);
            }
        }
    }
}

