/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.TextOutput;
import com.softsynth.wire.LoaderContext;
import com.softsynth.wire.Module;
import com.softsynth.wire.ModuleLoader;
import com.softsynth.wire.Patch;
import com.softsynth.wire.SampleModule;
import java.io.File;
import java.util.Hashtable;

class SampleLoader
extends ModuleLoader {
    File file = null;
    int frames;
    int channels;
    double frequency;
    boolean autoStop;

    public SampleLoader(String tag, LoaderContext ldcon) {
        super(tag, ldcon);
    }

    void handleSampleFormatAttributes(Hashtable attributes) {
        this.channels = this.getAttribute(attributes, "channels", 1);
        this.frames = this.getAttribute(attributes, "frames", 0);
    }

    void handleFrequencyAttributes(Hashtable attributes) {
        this.frequency = this.getAttribute(attributes, "value", 0.0);
    }

    void handleFlagsAttributes(Hashtable attributes) {
        this.autoStop = this.getAttribute(attributes, "autostop", 0) != 0;
    }

    @Override
    public void handleBeginElement(String tag, Hashtable attributes) {
        if (tag.equals("file")) {
            this.file = this.getResolvedFileAttribute(attributes, this.patch.getFile(), "name");
        } else if (tag.equals("flags")) {
            this.handleFlagsAttributes(attributes);
        } else if (tag.equals("format")) {
            this.handleSampleFormatAttributes(attributes);
        } else if (tag.equals("frequency")) {
            this.handleFrequencyAttributes(attributes);
        } else {
            super.handleBeginElement(tag, attributes);
        }
    }

    @Override
    public void handleEndElement() {
        this.setupModule(this.patch);
        super.handleEndElement();
    }

    @Override
    Module makeModule(Patch patch) {
        SampleModule sampleModule;
        if (this.file != null) {
            TextOutput.println("makeSample: file = " + this.file);
            sampleModule = patch.addSampleFromFile(this.name, this.file);
            if (sampleModule == null) {
                throw new RuntimeException("couldn't load sample from " + this.file);
            }
        } else {
            sampleModule = patch.addSample(this.name, this.frames, this.channels);
        }
        if (this.frequency > 0.0) {
            sampleModule.getSample().setBaseFrequency(this.frequency);
        }
        return sampleModule;
    }
}

