/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.wire.BarGraphDisplay;
import com.softsynth.wire.DraggableCanvas;
import com.softsynth.wire.InputGetJack;
import com.softsynth.wire.LabelledCanvas;
import com.softsynth.wire.Module;
import com.softsynth.wire.NumericValueSaverJack;
import com.softsynth.wire.WireJack;
import com.softsynth.wire.WireRangeEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

class VuDisplayModule
extends Module
implements Runnable {
    SynthDistributor distributor;
    BarGraphDisplay display;
    NumericValueSaverJack displayJack;
    InputGetJack inJack;
    Thread thread;
    int width = 20;
    int runIndex = 0;
    double filteredValue = 0.0;

    VuDisplayModule() {
    }

    @Override
    public void calculateSize() {
        this.panel.setSize(this.width, 160);
    }

    @Override
    public void start() {
        this.stop();
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void stop() {
        ++this.runIndex;
    }

    @Override
    public void run() {
        int startIndex = this.runIndex;
        while (startIndex == this.runIndex) {
            try {
                Thread.sleep(33L);
                try {
                    this.updateRanges();
                    this.updateDisplay();
                }
                catch (SynthException synthException) {}
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void updateDisplay() {
        double currentValue = Math.abs(this.inJack.get());
        if (currentValue >= this.filteredValue) {
            this.filteredValue = currentValue;
        } else {
            double filterCoefficient = 0.95;
            this.filteredValue = filterCoefficient * this.filteredValue;
            if (this.filteredValue < 1.0E-5) {
                this.filteredValue = 1.0E-5;
            }
        }
        this.display.set(this.filteredValue);
    }

    void updateRanges() {
        this.display.setMin(this.displayJack.getMin());
        this.display.setMax(this.displayJack.getMax());
    }

    @Override
    String getTagName() {
        return "misc";
    }

    @Override
    void addDragger() {
        this.panel.setLayout(new BorderLayout());
        this.calculateSize();
        this.dragger = new DraggableCanvas("VU");
        this.panel.add((Component)this.dragger, "North");
        this.dragger.setPreferredSize(new Dimension(this.width, 18));
        this.dragger.setWireJack(new WireJack(this, this.dragger, this.getName()));
        this.dragger.getWireJack().setDragged(this);
        this.dragger.addMouseListener(this.patch.getPatchPanel());
        this.dragger.addMouseMotionListener(this.patch.getPatchPanel());
    }

    @Override
    public void setupJacks() {
        this.display = new BarGraphDisplay(1, 0.7, -1.0, 1.0);
        this.panel.add((Component)this.display, "Center");
        this.displayJack = new NumericValueSaverJack(this, this.display, "vu");
        this.addJack(this.displayJack);
        this.updateRanges();
        this.setupConnectorJack();
    }

    public void setupConnectorJack() {
        this.distributor = new SynthDistributor(null, "DISTRO", 7);
        this.distributor.setup(0.0, 0.0, 1.0);
        this.inJack = new InputGetJack((Module)this, "*", this.distributor);
        LabelledCanvas lcan = (LabelledCanvas)this.inJack.getComponent();
        this.panel.add((Component)lcan, "South");
        this.addJack(this.inJack);
        lcan.setWireJack(this.inJack);
        lcan.setPreferredSize(new Dimension(this.width, 18));
        lcan.addMouseListener(this.patch.getPatchPanel());
        lcan.addMouseMotionListener(this.patch.getPatchPanel());
    }

    @Override
    boolean edit() {
        WireRangeEditor editor = new WireRangeEditor(this.patch.getPatchPanel().getFrame(), this, this.displayJack);
        if (this.editorBounds != null) {
            editor.setBounds(this.editorBounds);
        }
        boolean result = editor.ask() == 1;
        this.editorBounds = editor.getBounds();
        if (result) {
            this.updateRanges();
            this.updateDisplay();
        }
        return result;
    }

    @Override
    boolean editAfterMake() {
        return this.edit();
    }
}

