/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.wire.LabelledTextField;
import com.softsynth.wire.WireJack;
import com.softsynth.wire.WireUpdater;
import java.awt.GridLayout;
import java.awt.Panel;

class WireRangeUpdater
extends Panel
implements WireUpdater {
    WireJack port;
    LabelledTextField minText;
    LabelledTextField maxText;
    LabelledTextField valueText;

    public WireRangeUpdater(WireJack port) {
        this.port = port;
        this.setLayout(new GridLayout(1, 0));
        this.minText = new LabelledTextField("Minimum:", Double.toString(port.getMin()), 10);
        this.add(this.minText);
        this.valueText = new LabelledTextField("Value:", Double.toString(port.get()), 10);
        this.add(this.valueText);
        this.maxText = new LabelledTextField("Maximum:", Double.toString(port.getMax()), 10);
        this.add(this.maxText);
        this.validate();
    }

    @Override
    public void update() {
    }

    @Override
    public boolean applyEdit() {
        double val;
        double max;
        double min;
        try {
            min = this.minText.getDouble();
            max = this.maxText.getDouble();
            val = this.valueText.getDouble();
        }
        catch (NumberFormatException e) {
            return true;
        }
        this.port.setMin(min);
        this.port.setMax(max);
        this.port.set(val);
        return false;
    }
}

