/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.JackInABox;
import com.syntona.gui.patch.JackPartner;
import com.syntona.gui.patch.LabelledCanvas;
import com.syntona.gui.patch.ModulePartner;
import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PatchGlobals;
import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.SyntonaModel;
import com.syntona.plugin.SyntonaModelListener;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;

public class GenericModuleView
extends ModuleView {
    private static final int JACK_COMP_HEIGHT = 24;
    private static final int JACK_COMP_WIDTH = 70;
    private LabelledCanvas header;

    public GenericModuleView(ModulePresenter presenter) {
        super(presenter);
    }

    public GenericModuleView() {
    }

    @Override
    public LayoutManager makeLayout() {
        return new GridLayout(0, 1);
    }

    @Override
    public void makeJacks() {
        Jack[] jacks;
        Jack[] jackArray = jacks = this.getModule().getJacks();
        int n = jacks.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            this.addJack(jack);
            ++n2;
        }
        int height = this.getComponentCount() * 24;
        this.setSize(70, height);
    }

    private JComponent createJackView(Jack jack) {
        if (jack instanceof InputActionJack) {
            return this.createActionJackView(jack);
        }
        return this.createBasicJackView(jack);
    }

    private JComponent createBasicJackView(final Jack jack) {
        final JackInABox comp = new JackInABox(jack);
        if (jack.isOutput()) {
            comp.setAlignment(4);
        }
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                comp.setText(jack.getValueText());
            }

            @Override
            public void mouseExited(MouseEvent me) {
                comp.setText(jack.getName());
            }
        });
        jack.addModelListener(new SyntonaModelListener(){

            @Override
            public void nameChanged(SyntonaModel syntonaModel) {
                comp.setText(syntonaModel.getName());
            }

            @Override
            public void onOffChanged(SyntonaModel syntonaModel, boolean onOrOff) {
                comp.setOn(onOrOff);
            }
        });
        return comp;
    }

    private JComponent createActionJackView(final Jack jack) {
        JButton onButton = new JButton(jack.getName());
        onButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((InputActionJack)jack).execute();
            }
        });
        this.addComponent(onButton);
        return onButton;
    }

    @Override
    public void addJack(Jack jack) {
        if (!this.containsJack(jack)) {
            super.addJack(jack);
            JComponent comp = this.createJackView(jack);
            Color color = jack.getColor();
            comp.setBackground(color);
            new JackPartner(comp, this.getPresenter(), jack);
            comp.setToolTipText(jack.getToolTipText());
            this.addComponent(comp);
            int height = this.getComponentCount() * 24;
            this.setSize(70, height);
        }
    }

    @Override
    public JComponent makeHeader() {
        String name = this.getModule().getName();
        this.header = new LabelledCanvas(name);
        this.header.setBackground(PatchGlobals.getHeaderColor());
        new ModulePartner(this.header, this.getPresenter());
        this.addComponent(this.header, null, 0);
        this.header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                GenericModuleView.this.header.setText(GenericModuleView.this.getModule().getType());
            }

            @Override
            public void mouseExited(MouseEvent me) {
                GenericModuleView.this.header.setText(GenericModuleView.this.getModule().getName());
            }
        });
        return this.header;
    }

    @Override
    public void updateName() {
        this.header.setText(this.getModule().getName());
    }
}

