/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.softsynth.tools.view.JTextFieldDouble;
import com.syntona.gui.patch.HeaderBox;
import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PlayOverrideFocusListener;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.ModulePresenter;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextValueModuleView
extends ModuleView {
    private static final int HEIGHT = 40;
    private static final int WIDTH = 90;

    public TextValueModuleView() {
        this.setSize(90, 40);
    }

    public TextValueModuleView(ModulePresenter presenter) {
        super(presenter);
        this.setSize(90, 40);
    }

    @Override
    public void makeJacks() {
        this.makeVerticalJackBoxes();
        final InputDoubleJack inJack = (InputDoubleJack)this.getModule().getJackByName("in");
        final JTextFieldDouble textField = new JTextFieldDouble(inJack.getValue(), 8);
        inJack.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (textField.getValue() != inJack.getValue()) {
                    textField.setValue(inJack.getValue());
                }
            }
        });
        textField.addFocusListener(new PlayOverrideFocusListener());
        Insets insets = this.getInsets();
        int y = 30 - insets.top - insets.bottom;
        textField.setSize(74, y);
        textField.setLocation(insets.left + 8, insets.top + 10);
        this.addComponent(textField);
        textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    double tval = textField.getValue();
                    if (tval != inJack.getValue()) {
                        TextValueModuleView.this.getEngineController().sendPatchMessageDouble(inJack, tval);
                    }
                }
                catch (NumberFormatException e) {
                    textField.setText("Error!");
                    textField.selectAll();
                }
                TextValueModuleView.this.getEngineController().sendKickModule(TextValueModuleView.this.getModule());
            }
        });
    }

    @Override
    public JComponent makeHeader() {
        HeaderBox header = this.createTopHeaderBox(this.getWidth());
        this.addComponent(header);
        return header;
    }
}

