/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import com.syntona.model.SyntonaCommand;
import com.syntona.model.SyntonaEngine;
import com.syntona.plugin.Jack;
import com.syntona.plugin.SyntonaModule;

public class ConnectJacksCommand
implements SyntonaCommand {
    int sourceModuleId;
    String sourceJackName;
    int targetModuleId;
    String targetJackName;

    public ConnectJacksCommand(int sourceModuleId, String sourceJackName, int targetModuleId, String targetJackName) {
        this.sourceModuleId = sourceModuleId;
        this.sourceJackName = sourceJackName;
        this.targetModuleId = targetModuleId;
        this.targetJackName = targetJackName;
    }

    @Override
    public void execute() {
        SyntonaEngine syntonaEngine = SyntonaEngine.getInstance();
        SyntonaModule sourceModule = syntonaEngine.getModuleById(this.sourceModuleId);
        Jack sourceJack = sourceModule.getJackByName(this.sourceJackName);
        if (sourceJack == null) {
            System.err.println("Jack " + this.sourceJackName + " not found.");
        } else {
            SyntonaModule targetModule = syntonaEngine.getModuleById(this.targetModuleId);
            Jack targetJack = targetModule.getJackByName(this.targetJackName);
            if (targetJack == null) {
                System.err.println("Jack " + this.targetJackName + " not found.");
            } else {
                sourceJack.connect(targetJack);
            }
        }
    }

    @Override
    public void undo() {
    }
}

