/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.music.BeatTimer;
import com.syntona.model.music.BeatTimerTask;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.plugin.PatchMessageDouble;
import com.syntona.plugin.SyntonaModule;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;

public class BeatClockModule
extends SyntonaModule {
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String TAG_DIV = "match";
    private OutputDoubleJack output = new OutputDoubleJack(this, "out");
    private BeatTimer beatTimer = new BeatTimer();

    public BeatClockModule() {
        super("Send message on divisions of a beat.");
        BeatTimerTask task = new BeatTimerTask(){

            @Override
            public void execute(int index) {
                PatchMessageDouble msg = new PatchMessageDouble(index);
                BeatClockModule.this.output.passMessage(msg);
            }
        };
        this.beatTimer.scheduleTask(task, this.getDivisor());
    }

    public void setDivisor(int divisor) {
        this.beatTimer.setDivisor(divisor);
    }

    public int getDivisor() {
        return this.beatTimer.getDivisor();
    }

    @Override
    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        saver.beginElement(TAG_DIV);
        saver.addAttribute(ATTRIBUTE_VALUE, this.getDivisor());
        saver.endElement();
    }

    @Override
    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException {
        Element envelopeElement = XMLDOMLoader.getChildByTagName(moduleElement, TAG_DIV);
        if (envelopeElement != null) {
            int div = XMLDOMLoader.parseIntegerAttribute(envelopeElement, ATTRIBUTE_VALUE, this.getDivisor());
            this.setDivisor(div);
        }
    }
}

