/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import com.transjam.awt.StringResources;
import com.transjam.awt.WorldMapFrame;
import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class ChatPanel
extends Panel {
    private Button worldButton;
    static final Color chatBackground = new Color(250, 250, 220);
    static final Color usersBackground = new Color(200, 200, 220);
    public static final int MAX_NAME_SHOWN = 12;
    private int maxChars = 8192;
    private Client client;
    private ClientAdapter clientAdapter;
    private int numChars = 0;
    private TextArea chatDisplay;
    private TextArea userDisplay;
    private TextField chatEntry;
    private Checkbox heyBox;
    private Button exitButton;
    private WorldMapFrame worldMapFrame;
    private Hashtable clients;

    public ChatPanel(Client pClient) {
        this(pClient, 20, 70, true);
    }

    public ChatPanel(Client pClient, int numRows, int numColumns, boolean allowExit) {
        this.setEnabled(false);
        this.client = pClient;
        this.clients = new Hashtable();
        this.setLayout(new BorderLayout());
        this.worldMapFrame = new WorldMapFrame("User Locations", pClient);
        this.worldMapFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChatPanel.this.worldMapFrame.hide();
            }
        });
        Panel centerPanel = new Panel(new BorderLayout());
        this.add("Center", centerPanel);
        this.chatDisplay = new TextArea("TransJam Chat\n", numRows, numColumns, 1);
        this.chatDisplay.setEditable(false);
        this.chatDisplay.setBackground(chatBackground);
        centerPanel.add("Center", this.chatDisplay);
        this.chatEntry = new TextField(StringResources.TYPE_MESSAGE_HERE, numColumns);
        centerPanel.add("South", this.chatEntry);
        Panel eastPanel = new Panel(new BorderLayout());
        this.add("East", eastPanel);
        this.userDisplay = new TextArea("", 1, 12, 3);
        this.userDisplay.setEditable(false);
        this.userDisplay.setBackground(usersBackground);
        eastPanel.add("Center", this.userDisplay);
        Panel topButtonPanel = new Panel();
        topButtonPanel.setLayout(new GridLayout(0, 1));
        eastPanel.add("North", topButtonPanel);
        this.worldButton = new Button(StringResources.SHOW_MAP);
        topButtonPanel.add(this.worldButton);
        this.worldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatPanel.this.worldMapFrame.show();
            }
        });
        if (allowExit) {
            this.exitButton = new Button(StringResources.EXIT_ROOM);
            topButtonPanel.add(this.exitButton);
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChatPanel.this.exitButton.setEnabled(false);
                    ChatPanel.this.exitRoom();
                }
            });
        }
        Panel buttonPanel = new Panel();
        ((FlowLayout)buttonPanel.getLayout()).setVgap(0);
        eastPanel.add("South", buttonPanel);
        this.heyBox = new Checkbox(StringResources.HEY);
        buttonPanel.add(this.heyBox);
        this.chatEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = ChatPanel.this.chatEntry.getText();
                try {
                    if (text.length() > 0) {
                        int flags = 0;
                        if (ChatPanel.this.heyBox.getState()) {
                            flags |= 1;
                            ChatPanel.this.heyBox.setState(false);
                        }
                        ChatPanel.this.client.sendChat(String.valueOf(text) + "\n", flags);
                    }
                    ChatPanel.this.chatEntry.setText("");
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        this.clientAdapter = new ClientAdapter(){

            @Override
            public void sentChat(int uid, int flags, String text) {
                if ((flags & 1) != 0 && uid != ChatPanel.this.client.getUserID()) {
                    ChatPanel.this.getAttention();
                }
                ChatPanel.this.append(String.valueOf(ChatPanel.this.client.getUserName(uid)) + "> " + text);
            }

            @Override
            public void addedUser(int uid, String name) {
                Integer intUID = new Integer(uid);
                if (ChatPanel.this.clients.get(intUID) == null) {
                    ChatPanel.this.appendSystem(String.valueOf(name) + " arrived " + new Date() + "\n");
                    if (name.length() > 12) {
                        name = name.substring(0, 12);
                    }
                    ChatPanel.this.clients.put(intUID, name);
                    ChatPanel.this.userDisplay.append(String.valueOf(name) + "\n");
                }
            }

            @Override
            public void deletedUser(int uid, String text) {
                ChatPanel.this.appendSystem(String.valueOf(text) + " departed" + new Date() + "\n");
                ChatPanel.this.clients.remove(new Integer(uid));
                ChatPanel.this.updateUsers();
            }

            @Override
            public void sentBroadcast(String text) {
                ChatPanel.this.getAttention();
                ChatPanel.this.appendSystem("!!! SYSOP> " + text + "\n");
            }

            @Override
            public void enteredRoom(String name, int level) throws IOException {
                ChatPanel.this.appendSystem(String.valueOf(StringResources.ENTERING_ROOM) + ": " + name + "\n");
                ChatPanel.this.client.requestUserList();
                ChatPanel.this.setEnabled(true);
                ChatPanel.this.getAttention();
                if (ChatPanel.this.exitButton != null) {
                    ChatPanel.this.exitButton.setEnabled(true);
                }
            }

            @Override
            public void exitedRoom(String name, int level) throws IOException {
                ChatPanel.this.appendSystem(String.valueOf(StringResources.LEAVING_ROOM) + ": " + name + "\n");
                ChatPanel.this.clients.clear();
                ChatPanel.this.userDisplay.setText("");
                ChatPanel.this.setEnabled(false);
            }

            @Override
            public void serverDown(Client client) {
                ChatPanel.this.appendSystem(StringResources.SERVER_DISCONNECTED);
                ChatPanel.this.setEnabled(false);
            }
        };
    }

    public void exitRoom() {
        try {
            this.client.leaveRoom();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void start() {
        this.stop();
        this.client.addMessageListener(this.clientAdapter, 2);
    }

    public void stop() {
        this.client.removeMessageListener(this.clientAdapter, 2);
    }

    private void updateUsers() {
        Enumeration enumer = this.clients.elements();
        this.userDisplay.setText("");
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            this.userDisplay.append(String.valueOf(name) + "\n");
        }
    }

    public void getAttention() {
        Container comp = this;
        while ((comp = comp.getParent()) != null) {
            if (!(comp instanceof Window)) continue;
            Window window = (Window)comp;
            window.hide();
            window.show();
            window.toFront();
            break;
        }
    }

    public void append(String text) {
        int len = text.length();
        if (this.numChars + len > this.maxChars) {
            int numKill = this.maxChars / 4;
            this.chatDisplay.replaceRange("", 0, numKill);
            this.numChars -= numKill;
        }
        this.chatDisplay.append(text);
        this.numChars += len;
    }

    public void appendSystem(String text) {
        this.append("---------- " + text);
    }
}

