/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.Tuning;

public class JustTuning
implements Tuning {
    double fundamental;
    double[] tuning;
    static double[] defaultTuning = new double[]{1.0, 1.25, 1.3333333333333333, 1.5, 1.6666666666666667};

    public JustTuning(double fundamental, double[] tuning) {
        this.setFundamental(fundamental);
        this.tuning = tuning;
    }

    public JustTuning() {
        this(110.0, defaultTuning);
    }

    @Override
    public void setFundamental(double frequency) {
        this.fundamental = frequency;
    }

    @Override
    public double getFundamental() {
        return this.fundamental;
    }

    @Override
    public int getNotesPerOctave() {
        return this.tuning.length;
    }

    @Override
    public double pitchToFrequency(int pitch) {
        int index = 0;
        try {
            int notesPerOctave = this.tuning.length;
            int octave = pitch / notesPerOctave;
            index = pitch - octave * notesPerOctave;
            return this.tuning[index] * (double)(1 << octave) * this.fundamental;
        }
        catch (Exception exc) {
            System.err.println("JustTuning.pitchToFrequency caught: " + exc);
            System.err.println("JustTuning.pitchToFrequency: pitch = " + pitch + ", index = " + index);
            return 5000.0;
        }
    }
}

