/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.EqualTuning;
import com.transjam.drumbox.JustTuning;
import com.transjam.drumbox.TrackModel;
import com.transjam.drumbox.Tuning;
import java.util.Observable;

public class SongModel
extends Observable {
    private static final double DEFAULT_BPM = 220.0;
    private double beatsPerMinute = 220.0;
    private int tuningIndex;
    private int fundamentalPitch = 36;
    private TrackModel[] trackModels;
    private int numTracks;
    private String[] tuningNames = new String[]{"12T ET Major", "12T ET Minor", "5T Just"};
    private Tuning[] tunings = new Tuning[]{new EqualTuning(), new EqualTuning(), new JustTuning()};
    private int maxInTimeOf;

    public SongModel(int numTracks) {
        this.numTracks = numTracks;
        this.trackModels = new TrackModel[numTracks];
        ((EqualTuning)this.tunings[1]).useMinorScale();
        int i = 0;
        while (i < numTracks - 2) {
            this.trackModels[i] = new TrackModel(this, i, 1);
            ++i;
        }
        this.trackModels[i] = new TrackModel(this, i, 11);
        this.trackModels[++i] = new TrackModel(this, i, 11);
        ++i;
        this.reset();
    }

    public void reset() {
        int i = 0;
        while (i < this.numTracks) {
            this.trackModels[i].reset();
            ++i;
        }
        this.trackModels[0].setBeatPitch(0, 0);
        this.trackModels[0].setBeatVolume(0, 2);
        this.setTuningSelection(0);
        this.setBeatsPerMinute(220.0);
    }

    public TrackModel getTrack(int trackIndex) {
        return this.trackModels[trackIndex];
    }

    public int getNumTracks() {
        return this.numTracks;
    }

    public TrackModel findLongestTrack() {
        TrackModel track = null;
        this.maxInTimeOf = -1;
        int i = 0;
        while (i < this.numTracks) {
            int beats = this.trackModels[i].getInTimeOf();
            if (beats > this.maxInTimeOf) {
                this.maxInTimeOf = beats;
                track = this.trackModels[i];
            }
            ++i;
        }
        return track;
    }

    public int getMaxInTimeOf() {
        return this.maxInTimeOf;
    }

    public void setBeatsPerMinute(double pBeatsPerMinute) {
        this.beatsPerMinute = pBeatsPerMinute;
        this.sully();
    }

    public double getBeatsPerMinute() {
        return this.beatsPerMinute;
    }

    public String[] getTuningNames() {
        return this.tuningNames;
    }

    public void setTuningSelection(int pTuningIndex) {
        this.tuningIndex = pTuningIndex;
        this.updateTuning();
        this.sully();
    }

    public int getTuningSelection() {
        return this.tuningIndex;
    }

    private void updateTuning() {
        this.tunings[this.tuningIndex].setFundamental(EqualTuning.getMIDIFrequency(this.fundamentalPitch));
    }

    public void setFundamental(int pitch) {
        this.fundamentalPitch = pitch;
        this.updateTuning();
        this.sully();
    }

    public int getFundamental() {
        return this.fundamentalPitch;
    }

    public Tuning getTuning() {
        return this.tunings[this.tuningIndex];
    }

    void sully() {
        this.setChanged();
        this.notifyObservers();
    }
}

