/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.SongModel;
import java.util.Observable;
import java.util.Observer;

public class TrackModel
extends Observable {
    private int trackIndex = -1;
    private int[] volumes;
    private int[] pitches;
    private int numBeats;
    private int inTimeOf;
    private int instrumentIndex;
    private int defaultInstrumentIndex;
    private int pitchOffset = 0;
    private double volume;
    private double pan;
    private boolean reversed = false;
    private double noteProbability;
    private SongModel songModel;
    private int numPitchLevels;
    static final int NUM_BEATS = 16;
    static final int MAX_BEATS = 32;
    public static final int CHANGED_OTHER = 0;
    public static final int CHANGED_BEATS = 1;
    public static final int CHANGED_NOTE = 2;
    Integer argChangedOther = new Integer(0);
    Integer argChangedBeats = new Integer(1);
    Integer argChangedNote = new Integer(2);

    public TrackModel(SongModel songModel, int trackIndex, int numPitchLevels) {
        this.songModel = songModel;
        this.numPitchLevels = numPitchLevels;
        this.trackIndex = trackIndex;
        this.setMaxBeats(32);
        this.reset();
    }

    public void reset() {
        this.clear();
        this.setNumBeats(16);
        this.setInTimeOf(16);
        this.setReversed(false);
        this.setVolume(0.5);
        this.setPan(0.0);
        this.setProbability(1.0);
        this.setInstrumentIndex(this.defaultInstrumentIndex);
    }

    public void setBeatVolume(int beatIndex, int volume) {
        this.volumes[beatIndex] = volume;
        this.changed(this.argChangedNote);
    }

    public int getBeatVolume(int beatIndex) {
        return this.volumes[beatIndex];
    }

    public int getTrackIndex() {
        return this.trackIndex;
    }

    public double getVolume() {
        return this.volume;
    }

    public void tweakVolume(double vol) {
        this.volume = vol;
    }

    public void setVolume(double vol) {
        this.volume = vol;
        this.changed(this.argChangedOther);
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double pan) {
        this.pan = pan;
        this.changed(this.argChangedOther);
    }

    public void tweakPan(double pan) {
        this.pan = pan;
    }

    public double getProbability() {
        return this.noteProbability;
    }

    public void tweakProbability(double prob) {
        this.noteProbability = prob;
    }

    public void setProbability(double prob) {
        this.noteProbability = prob;
        this.changed(this.argChangedOther);
    }

    public void clear() {
        int i = 0;
        while (i < this.volumes.length) {
            this.volumes[i] = 0;
            this.pitches[i] = 0;
            ++i;
        }
        this.changed(this.argChangedNote);
    }

    public void setBeatPitch(int beatIndex, int pitch) {
        this.pitches[beatIndex] = pitch;
        this.changed(this.argChangedNote);
    }

    public int getBeatPitch(int beatIndex) {
        return this.pitches[beatIndex];
    }

    public void setBeatVolumePitch(int beatIndex, int volume, int pitch) {
        this.volumes[beatIndex] = volume;
        this.pitches[beatIndex] = pitch;
        this.changed(this.argChangedNote);
    }

    public int getNumPitchLevels() {
        return this.numPitchLevels;
    }

    public void setDefaultInstrumentIndex(int insIndex) {
        this.defaultInstrumentIndex = insIndex;
        this.changed(this.argChangedOther);
    }

    public void setInstrumentIndex(int insIndex) {
        this.instrumentIndex = insIndex;
        this.changed(this.argChangedOther);
    }

    public int getInstrumentIndex() {
        return this.instrumentIndex;
    }

    public void setPitchOffset(int offset) {
        this.pitchOffset = offset;
        this.changed(this.argChangedOther);
    }

    public int getPitchOffset() {
        return this.pitchOffset;
    }

    public void setReversed(boolean rev) {
        this.reversed = rev;
        this.changed(this.argChangedOther);
    }

    public boolean getReversed() {
        return this.reversed;
    }

    public void setNumBeats(int pNumBeats) {
        this.numBeats = pNumBeats;
        this.changed(this.argChangedBeats);
    }

    public int getNumBeats() {
        return this.numBeats;
    }

    public void setInTimeOf(int pInTimeOf) {
        this.inTimeOf = pInTimeOf;
        this.changed(this.argChangedBeats);
    }

    public int getInTimeOf() {
        return this.inTimeOf;
    }

    public void setMaxBeats(int pMaxBeats) {
        this.volumes = new int[pMaxBeats];
        this.pitches = new int[pMaxBeats];
        this.changed(this.argChangedBeats);
    }

    public int getMaxBeats() {
        if (this.volumes == null) {
            return 0;
        }
        return this.volumes.length;
    }

    public SongModel getSongModel() {
        return this.songModel;
    }

    void changed(Object arg) {
        if (!this.hasChanged()) {
            this.setChanged();
            this.notifyObservers(arg);
        }
    }

    @Override
    public void addObserver(Observer ob) {
        super.addObserver(ob);
        this.changed(this.argChangedOther);
        this.changed(this.argChangedBeats);
    }
}

