/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.ValueGridEvent;
import com.transjam.drumbox.ValueGridListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ValueGrid
extends Canvas {
    int numRows;
    int numColumns;
    int maxColumns;
    int minSide = 10;
    int inset = 1;
    int cursorHeight = 4;
    int cursorColumn = 1;
    int factor = 1;
    Color[] enabledColors;
    Color[] disabledColors;
    Color cursorColor;
    int lastRow = -1;
    int lastColumn = -1;
    Vector listeners;
    boolean useFixedWidth = false;
    private static final int DOWN_EVENT = 0;
    private static final int DRAG_EVENT = 1;
    private static final int UP_EVENT = 2;
    boolean ifMouseActive = false;
    MouseAdapter mouseAdapter;
    MouseMotionAdapter mouseMotionAdapter;
    static final int[] preferredFactors = new int[]{4, 5, 3, 7, 11, 13};

    public ValueGrid(int pNumRows, int pNumColumns, Color[] pEnabledColors, Color[] pDisabledColors, Color pCursorColor) {
        this.numRows = pNumRows;
        this.setNumColumns(pNumColumns);
        this.setMaxColumns(pNumColumns);
        this.enabledColors = pEnabledColors;
        this.disabledColors = pDisabledColors;
        this.cursorColor = pCursorColor;
        this.listeners = new Vector();
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = ValueGrid.this.yToRow(e.getY());
                int column = ValueGrid.this.xToColumn(e.getX());
                if (column < ValueGrid.this.numColumns) {
                    ValueGrid.this.ifMouseActive = true;
                    ValueGrid.this.processMouse(0, row, column);
                    ValueGrid.this.lastRow = row;
                    ValueGrid.this.lastColumn = column;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ValueGrid.this.ifMouseActive) {
                    int row = ValueGrid.this.yToRow(e.getY());
                    int column = ValueGrid.this.xToColumn(e.getX());
                    if (column >= ValueGrid.this.numColumns) {
                        column = ValueGrid.this.numColumns - 1;
                    }
                    ValueGrid.this.processMouse(2, row, column);
                    ValueGrid.this.ifMouseActive = false;
                }
                ValueGrid.this.lastRow = -1;
                ValueGrid.this.lastColumn = -1;
            }
        };
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ValueGrid.this.ifMouseActive) {
                    int row = ValueGrid.this.yToRow(e.getY());
                    int column = ValueGrid.this.xToColumn(e.getX());
                    if (column < ValueGrid.this.numColumns && (row != ValueGrid.this.lastRow || column != ValueGrid.this.lastColumn)) {
                        ValueGrid.this.processMouse(1, row, column);
                        ValueGrid.this.lastRow = row;
                        ValueGrid.this.lastColumn = column;
                    }
                }
            }
        };
        this.setEnabled(true);
    }

    public abstract int getValue(int var1, int var2);

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.removeMouseListener(this.mouseAdapter);
        this.removeMouseMotionListener(this.mouseMotionAdapter);
        if (flag) {
            this.addMouseListener(this.mouseAdapter);
            this.addMouseMotionListener(this.mouseMotionAdapter);
        }
        this.repaint();
    }

    public void addValueGridListener(ValueGridListener listener) {
        this.listeners.addElement(listener);
    }

    void processMouse(int mode, int row, int column) {
        ValueGridEvent vge = new ValueGridEvent(this, row, column);
        Enumeration enumer = this.listeners.elements();
        while (enumer.hasMoreElements()) {
            ValueGridListener listener = (ValueGridListener)enumer.nextElement();
            switch (mode) {
                case 0: {
                    listener.gridDown(vge);
                    break;
                }
                case 1: {
                    listener.gridDragged(vge);
                    break;
                }
                case 2: {
                    listener.gridUp(vge);
                }
            }
        }
    }

    public void setNumColumns(int pNumColumns) {
        this.numColumns = pNumColumns;
        this.factor = this.getPreferredFactor(this.numColumns);
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setMaxColumns(int pMaxColumns) {
        this.maxColumns = pMaxColumns;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    int getPreferredFactor(int n) {
        int i = 0;
        while (i < preferredFactors.length) {
            int pfactor = preferredFactors[i];
            if (n % pfactor == 0) {
                return pfactor;
            }
            ++i;
        }
        return n;
    }

    int columnToX(int column) {
        int width = this.getBounds().width;
        int x = this.useFixedWidth ? column * (width / this.maxColumns) : width * column / this.maxColumns;
        return x;
    }

    int xToColumn(int x) {
        int col;
        int width = this.getBounds().width;
        if (this.useFixedWidth) {
            int colWidth = width / this.maxColumns;
            col = x / colWidth;
        } else {
            col = x * this.maxColumns / width;
        }
        if (col >= this.maxColumns) {
            col = this.maxColumns;
        } else if (col < 0) {
            col = 0;
        }
        return col;
    }

    int yToRow(int y) {
        int height = this.getBounds().height - this.cursorHeight;
        int rowHeight = height / this.numRows;
        int row = (y - this.cursorHeight) / rowHeight;
        if (row >= this.numRows) {
            row = this.numRows;
        }
        return row;
    }

    void drawCursor(Graphics g) {
        int x2;
        int x1;
        if (this.cursorColumn < 0) {
            return;
        }
        Color bgCol = this.getBackground();
        g.setColor(bgCol);
        g.fillRect(0, 0, this.getBounds().width, this.cursorHeight);
        int numSections = this.numColumns / this.factor;
        g.setColor(this.enabledColors[1]);
        int i = 0;
        while (i < numSections) {
            x1 = this.columnToX(i * this.factor);
            x2 = this.columnToX((i + 1) * this.factor);
            g.fillRect(x1, 0, x2 - x1, this.cursorHeight);
            i += 2;
        }
        g.setColor(this.cursorColor);
        x1 = this.columnToX(this.cursorColumn);
        x2 = this.columnToX(this.cursorColumn + 1);
        int wq = x2 - x1 >> 2;
        g.fillOval(x1 + wq, 0, wq + wq, this.cursorHeight);
    }

    public void setCursorColumn(int column) {
        this.cursorColumn = column;
        this.repaint(0, 0, this.getBounds().width, this.cursorHeight);
    }

    @Override
    public void paint(Graphics g) {
        Color[] colors = this.isEnabled() ? this.enabledColors : this.disabledColors;
        int width = this.getBounds().width;
        int height = this.getBounds().height - this.cursorHeight;
        int rowHeight = height / this.numRows;
        Color bgCol = this.getBackground();
        if (!this.isEnabled()) {
            bgCol = bgCol.darker();
        }
        g.setColor(bgCol);
        g.fillRect(0, this.cursorHeight, width, height);
        int x1 = this.columnToX(0);
        int j = 0;
        while (j < this.numColumns) {
            int x2 = this.columnToX(j + 1);
            int i = 0;
            while (i < this.numRows) {
                int val = this.getValue(i, j);
                g.setColor(colors[val]);
                int y = this.cursorHeight + this.inset + rowHeight * i;
                if (val > 0) {
                    g.fillOval(x1, y, x2 - x1 - this.inset * 2, rowHeight - this.inset * 2);
                } else {
                    g.drawRect(x1, y, x2 - x1 - this.inset * 2, rowHeight - this.inset * 2);
                }
                ++i;
            }
            x1 = x2;
            ++j;
        }
        this.drawCursor(g);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.numColumns * this.minSide, this.numRows * this.minSide + this.cursorHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

