/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.util;

import com.transjam.util.ClientMonitor;
import com.transjam.util.ClientMonitorListener;
import com.transjam.util.DebugLog;
import com.transjam.util.ProtocolWriter;
import com.transjam.util.TransjamMessage;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;

public abstract class ClientBase
implements ClientMonitorListener {
    public static final int LOGIN_LEVEL = 0;
    public static final int LOBBY_LEVEL = 1;
    public static final int APPLICATION_LEVEL = 2;
    public static final int DEFAULT_TIMEOUT_MSEC = 15000;
    private Socket socket;
    ClientMonitor monitor;
    private String name;
    private int id;
    private boolean active = true;
    private int timeoutMSec;
    public ProtocolWriter writer = new ProtocolWriter();
    public boolean ifValid = false;
    public boolean hadError = false;

    public ClientBase() {
        this.monitor = new ClientMonitor(this);
    }

    @Override
    public abstract void gotTimeout(int var1) throws IOException;

    @Override
    public abstract void gotThrowable(Throwable var1);

    @Override
    public abstract void gotMessage(TransjamMessage var1);

    @Override
    public abstract void gotStart();

    @Override
    public abstract void gotStop();

    public abstract void write(String var1) throws IOException;

    public void debugln(int code, String msg) {
        DebugLog.debugln(code, "#" + this.getUserID() + ", " + this.getName() + ": " + msg);
    }

    public synchronized void writeSocket(String msg) throws IOException {
        DebugLog.debugln(116, "sent: " + this.name + "(" + this.id + ") - " + msg);
        byte[] bar = msg.getBytes();
        this.socket.getOutputStream().write(bar);
        this.socket.getOutputStream().flush();
    }

    public void setSocket(Socket pSocket, int pTimeoutMSec) throws IOException {
        this.socket = pSocket;
        this.timeoutMSec = pTimeoutMSec;
        this.monitor.setSocket(pSocket, pTimeoutMSec);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getUserID() {
        return this.id;
    }

    public void setUserID(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
        this.monitor.start();
    }

    public synchronized void closeSocket(String reason) throws IOException {
        if (this.socket != null) {
            Socket mySocket = this.socket;
            this.socket = null;
            mySocket.close();
        }
    }

    public void beginGracefulShutdown() {
        this.monitor.stop();
    }

    public void stop() {
        this.monitor.stop();
    }

    public boolean isBroken() {
        return this.hadError;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
    }

    public boolean checkValidationMessage(String validationMsg) {
        this.ifValid = validationMsg.equals("TransJam - Copyright 2001 Phil Burk");
        return this.ifValid;
    }

    public void checkValidity() throws IOException {
        if (!this.ifValid) {
            throw new IOException("Client and server validity check failed!");
        }
    }

    public void requestValidation() throws IOException {
        this.write(this.writer.requestValidation());
    }

    public void sendSync(String msg) throws IOException {
        this.write(this.writer.sendSync(msg));
    }

    public void sendSelf(String msg) throws IOException {
        this.write(this.writer.sendSelf(msg));
    }

    public void sendOthers(String msg) throws IOException {
        this.write(this.writer.sendOthers(this.getUserID(), msg));
    }

    public void sendUser(int targetUserID, String msg) throws IOException {
        this.write(this.writer.sendUser(targetUserID, msg));
    }

    public void sendAll(String msg) throws IOException {
        this.write(this.writer.sendAll(this.getUserID(), msg));
    }

    public void requestEcho(String msg) throws IOException {
        this.write(this.writer.requestEcho(msg));
    }

    public void replyEcho(String msg) throws IOException {
        this.write(this.writer.sendEcho(msg));
    }

    public void modifyThing(String name, String contents) throws IOException {
        this.write(this.writer.modifyThing(name, contents));
    }

    public void deleteThing(String name) throws IOException {
        this.write(this.writer.deleteThing(name));
    }

    public void lockThing(String name) throws IOException {
        this.write(this.writer.lockThing(name));
    }

    public void denyLock(String name) throws IOException {
        this.write(this.writer.denyLock(name));
    }

    public void sendInfo(int version, String info) throws IOException {
        this.write(this.writer.sendInfo(version, info));
    }

    public void joinMeeting(Date when) throws IOException {
        this.write(this.writer.joinMeeting(when));
    }

    public void requestMeetingList() throws IOException {
        this.write(this.writer.requestMeetingList());
    }

    public void addMeeting(Date when, int numClients) throws IOException {
        this.write(this.writer.addMeeting(when, numClients));
    }
}

