/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import compmus.DelayLab;
import java.awt.Label;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class DelayLabSample
extends DelayLab {
    SampleReader_16V1 samplePlayer;
    boolean isApplet = true;
    Label statusLabel;
    static final String FILENAME1 = "chewymonkeys.wav";

    public static void main(String[] args) {
        DelayLabSample applet = new DelayLabSample();
        AppletFrame frame = new AppletFrame("Play With It", applet);
        applet.isApplet = false;
        frame.resize(600, 460);
        frame.show();
        frame.test();
    }

    @Override
    public void setupSource() {
        this.statusLabel = new Label("Wait for sample to be loaded.", 1);
        this.add(this.statusLabel);
        SLoader loader = new SLoader(FILENAME1);
        loader.start();
    }

    private void useSample(SynthSample sample) {
        this.samplePlayer = new SampleReader_16V1();
        this.samplePlayer.rate.set(sample.getSampleRate());
        this.samplePlayer.output.connect(this.combFilter.input);
        this.samplePlayer.start();
        this.samplePlayer.samplePort.queueLoop(sample);
    }

    public SynthSample readHolderFromFile(String fileName) throws SynthException {
        InputStream stream = null;
        SynthSample sample = null;
        try {
            if (this.isApplet) {
                System.out.println("CodeBase = " + this.getCodeBase());
                System.out.println("Path = " + this.getCodeBase());
                URL sampleURL = new URL(this.getCodeBase(), fileName);
                stream = sampleURL.openConnection().getInputStream();
            } else {
                stream = new FileInputStream(fileName);
            }
            switch (SynthSample.getFileType(fileName)) {
                case 1: {
                    sample = new SynthSampleAIFF();
                    break;
                }
                case 2: {
                    sample = new SynthSampleWAV();
                    break;
                }
                default: {
                    SynthAlert.showError("Unrecognized sample file suffix.");
                }
            }
            sample.load(stream);
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            SynthAlert.showError(e);
        }
        catch (SecurityException e) {
            SynthAlert.showError(e);
        }
        return sample;
    }

    class SLoader
    extends Thread {
        String fileName;

        public SLoader(String pFileName) {
            this.fileName = pFileName;
        }

        @Override
        public void run() {
            SynthSample sample = DelayLabSample.this.readHolderFromFile("samples/" + this.fileName);
            if (sample != null) {
                DelayLabSample.this.useSample(sample);
                DelayLabSample.this.statusLabel.setText("Sample loaded.");
            }
        }
    }
}

